/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentCompletenessAnalyzerBase;
import com.teamscale.index.comment_analysis.CommentFindingAnalysisBase;
import com.teamscale.index.comment_analysis.ECommentCategory;
import com.teamscale.index.comment_analysis.classification.CoherenceUtils;
import com.teamscale.index.comment_analysis.classification.MethodFinder;
import com.teamscale.index.comment_analysis.identifier.CompoundBreaker;
import com.teamscale.index.comment_analysis.utils.CommentUtils;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

public abstract class InterfaceCommentCoherenceAnalysisBase
extends CommentFindingAnalysisBase {
    private static final Pattern NON_IDENTIFIER_PATTERN = Patterns.SINGLE_NON_WORD_CHARACTER;
    private static final Pattern JAVADOC_AT_LINK_OR_VALUE_TAG_PATTERN = Pattern.compile("\\{@(link|value) #?(.*?)\\}");

    protected InterfaceCommentCoherenceAnalysisBase(String findingGroupKey) {
        super(findingGroupKey);
    }

    @Override
    protected void analyzeComment(Comment comment, ECommentCategory category) throws ConQATException {
        if (category != ECommentCategory.INTERFACE) {
            return;
        }
        if (!CommentUtils.isDefaultComment(comment.getText()) && !CommentUtils.hasOnlyJavaDoc(comment.getText()) && InterfaceCommentCoherenceAnalysisBase.hasFollowupMethodOrIdentifier(comment)) {
            this.analyzeCoherence(comment);
        }
    }

    private static boolean hasFollowupMethodOrIdentifier(Comment comment) {
        List<IToken> nextTokens = comment.getNextTokens(comment.getTokenIndex(), 1);
        if (nextTokens.isEmpty()) {
            return false;
        }
        IToken nextToken = nextTokens.get(0);
        if (nextToken.getType() == ETokenType.IDENTIFIER) {
            return true;
        }
        return !StringUtils.isEmpty((String)comment.getMethodFinder().getNextDefinition(comment.getTokenIndex(), false));
    }

    protected static boolean hasCommentUnnecessaryReturn(Comment comment) {
        Comment commentHeadLine = InterfaceCommentCoherenceAnalysisBase.getCommentHeadline(comment, false);
        MethodFinder methodFinder = comment.getMethodFinder();
        boolean isMethodDefinition = methodFinder.isMethodDefinition(commentHeadLine.getTokenIndex());
        if (!isMethodDefinition) {
            return false;
        }
        IToken methodDefinitionTypeToken = methodFinder.getNextDefinitionType(commentHeadLine.getTokenIndex());
        String firstToken = (String)commentHeadLine.getCommentTokens().get(0);
        return StringUtils.containsIgnoreCase((String)firstToken, (String)ETokenType.RETURN.toString()) && methodDefinitionTypeToken.getType() == ETokenType.VOID;
    }

    protected abstract void analyzeCoherence(Comment var1) throws ConQATException;

    protected static double getCoherenceCoefficient(Comment comment) {
        String nextDefinition = comment.getMethodFinder().getNextDefinition(comment.getTokenIndex());
        if (StringUtils.isEmpty((String)nextDefinition)) {
            return -1.0;
        }
        if (NON_IDENTIFIER_PATTERN.matcher(nextDefinition).find() || "this".equals(nextDefinition)) {
            return -1.0;
        }
        String commentText = comment.getText();
        double numberOfCorrespondingWords = nextDefinition.length() == 1 && StringUtils.containsIgnoreCase((String)commentText, (String)nextDefinition) ? 1.0 : (double)CoherenceUtils.getNumCorrespondingWords(nextDefinition, commentText, comment.getLanguage());
        String[] parts = Patterns.WHITESPACE.split(commentText);
        if (parts.length == 0) {
            return -1.0;
        }
        double numWordsInComment = 0.0;
        for (String part : parts) {
            if (part.length() <= 1) continue;
            numWordsInComment += 1.0;
        }
        return numberOfCorrespondingWords / numWordsInComment;
    }

    protected static Comment getCommentHeadline(Comment comment, boolean includingReturn) {
        String text = comment.getText();
        text = InterfaceCommentCoherenceAnalysisBase.breakCompoundInJavadocLinkOrValueTag(text);
        text = CommentCompletenessAnalyzerBase.XMLTAG_PATTERN.matcher(text).replaceAll("");
        Object commentStringAdapted = StringUtils.getFirstParts((String)text, (int)1, (char)'@');
        String[] returnSplit = StringUtils.splitByWholeSeparator((String)text, (String)"@return");
        if (includingReturn && returnSplit.length > 1) {
            commentStringAdapted = (String)commentStringAdapted + StringUtils.getFirstParts((String)returnSplit[1], (int)1, (char)'@');
        }
        return new Comment((String)commentStringAdapted, comment.getTokenIndex(), comment.getAstPosition(), comment.getElementUniformPath(), (List<IToken>)comment.getTokens(), comment.getMethodFinder());
    }

    private static String breakCompoundInJavadocLinkOrValueTag(String commentText) {
        Matcher tagMatcher = JAVADOC_AT_LINK_OR_VALUE_TAG_PATTERN.matcher(commentText);
        StringBuffer tagReplaceBuffer = new StringBuffer();
        while (tagMatcher.find()) {
            tagMatcher.appendReplacement(tagReplaceBuffer, StringUtils.concat(CompoundBreaker.breakCompound(tagMatcher.group(2), true), (String)" "));
        }
        tagMatcher.appendTail(tagReplaceBuffer);
        return tagReplaceBuffer.toString();
    }
}

