/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import com.teamscale.index.findings.phpstan.PHPStanFindingSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.version.Version;

public class PHPStanConfiguration
extends ToolConfigurationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern PHP_VERSION_PATTERN = Pattern.compile("^PHP (\\d+\\.\\d+(?:\\.\\d+)?)\\s*");
    private static final Pattern COMPOSER_VERSION_PATTERN = Pattern.compile("^Composer (version )?(?<version>\\d+\\.\\d+(?:\\.\\d+)?)\\s*");
    private static final Version MINIMUM_PHP_VERSION = new Version(7, 2);
    private static final Version MINIMUM_COMPOSER_VERSION = new Version(2, 2);
    public static final String FINDING_CATEGORY = "PHPStan";
    private static final String DESCRIPTIONS_PATH = "phpstan";
    private static final String MAPPINGS_TSV = "phpstan/check-mappings.tsv";
    @ConfigExposed(name="PHPStan: Level", description="Custom rule level to pass to the \"level\" parameter of PHPStan.\nDefault is `-1` which translates to `max`.\n\n*Attention:*\nChanging this value leads to PHPStan checks being disabled, even when they are enabled in the analysis profile.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private CodeScopeAware<Integer> level = CodeScopeAware.defaultCodeScopeWithValue((Object)-1);
    @ConfigExposed(name="PHPStan: Ignore Errors", description="Custom values to pass to the \"ignoreErrors\" parameter of PHPStan.\nValues should be separated by new lines.\n", multilineText=true)
    private CodeScopeAware<List<String>> ignoreErrors = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @ConfigExposed(name="PHPStan: Additional Parameters", description="Additional boolean parameters to pass to the PHPStan analysis.\nE.g., `inferPrivatePropertyTypeFromConstructor` -> `true`\n", multilineText=true)
    private CodeScopeAware<PairList<String, Boolean>> additionalParameters = CodeScopeAware.defaultCodeScopeWithValue((Object)new PairList(Map.of("inferPrivatePropertyTypeFromConstructor", true)));

    public PHPStanConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.PHPSTAN, FINDING_CATEGORY, DESCRIPTIONS_PATH, MAPPINGS_TSV, "");
        this.declareCodeScopeAware();
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        PHPStanConfiguration.checkNativeZipPresence();
        TriggerBuilder triggerBuilder = new TriggerBuilder(PHPStanFindingSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setCost(ETriggerCost.EXPENSIVE);
        triggerBuilder.setTriggerParameter("active-rules", (ITriggerParameter)activeChecksPerCodeScope);
        triggerBuilder.setTriggerParameter("level", this.level);
        triggerBuilder.setTriggerParameter("ignore-errors", this.ignoreErrors);
        triggerBuilder.setTriggerParameter("additional-parameters", this.additionalParameters);
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    public void validateTools() throws ProjectConfigurationException {
        AnalysisToolsConfigurationUtils.checkProgramAvailability("php", PHPStanConfiguration::isPhpAvailable, true);
        PHPStanConfiguration.isComposerAvailable();
    }

    private static boolean isPhpAvailable(ProcessUtils.ExecutionResult result) {
        if (result.terminatedByTimeoutOrInterruption() || result.getReturnCode() != 0) {
            return false;
        }
        Matcher matcher = PHP_VERSION_PATTERN.matcher(result.getStdout());
        if (!matcher.find()) {
            return false;
        }
        try {
            return Version.parseVersion((String)matcher.group(1)).isGreaterOrEqual(MINIMUM_PHP_VERSION);
        }
        catch (FormatException e) {
            LOGGER.warn("Unable to parse PHP version from: {}", (Object)result.getStdout(), (Object)e);
            return false;
        }
    }

    public static boolean isComposerAvailable() {
        try {
            AnalysisToolsConfigurationUtils.checkProgramAvailability("composer", PHPStanConfiguration::isComposerAvailable, true);
            return true;
        }
        catch (ProjectConfigurationException e) {
            return false;
        }
    }

    private static boolean isComposerAvailable(ProcessUtils.ExecutionResult result) {
        Optional<String> composerError = PHPStanConfiguration.getComposerError(result);
        if (composerError.isPresent()) {
            LOGGER.warn("{} Teamscale will not be able to resolve composer dependencies during analysis.\n{}", (Object)composerError.get(), (Object)result);
            return false;
        }
        return true;
    }

    private static Optional<String> getComposerError(ProcessUtils.ExecutionResult result) {
        if (result.getReturnCode() != 0 || result.terminatedByTimeoutOrInterruption()) {
            return Optional.of("Failed to execute \"composer\".");
        }
        Matcher matcher = COMPOSER_VERSION_PATTERN.matcher(result.getStdout());
        if (!matcher.find()) {
            return Optional.of("Could not detect composer version.");
        }
        try {
            Version composerVersion = Version.parseVersion((String)matcher.group("version"));
            if (!composerVersion.isGreaterOrEqual(MINIMUM_COMPOSER_VERSION)) {
                return Optional.of("Composer version %s is older than the minimum required version %s.".formatted(composerVersion, MINIMUM_COMPOSER_VERSION));
            }
        }
        catch (FormatException e) {
            return Optional.of("Unable to parse composer version.");
        }
        return Optional.empty();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        if (!tools.contains(EAnalysisTool.PHPSTAN)) {
            return;
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("level", template.getCodeScope()));
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("ignoreErrors", template.getCodeScope()));
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("additionalParameters", template.getCodeScope()));
    }

    private static void checkNativeZipPresence() throws ProjectConfigurationException {
        Path nativeLib = PHPStanConfiguration.getPhpStanArchive();
        if (!Files.exists(nativeLib, new LinkOption[0])) {
            throw new ProjectConfigurationException("Bundled PHPStan installation was not found in path: " + String.valueOf(nativeLib.toAbsolutePath()));
        }
    }

    public static Path getPhpStanArchive() {
        return NativeLibUtil.getNativeLib((String)"phpstan/phpstan.phar").toPath();
    }
}

