/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;

public abstract class DataflowFindingsCreatorBase<ResultT extends DataflowAnalysisResult<?, ?>>
implements IDataflowFindingsCreator<ResultT> {
    public static final String FINDING_CATEGORY = "Dataflow";
    private final List<IFalsePositiveFilter> filters;
    private final String groupName;
    protected final ListMap<String, IndexFinding> findings = new ListMap();

    protected DataflowFindingsCreatorBase(List<IFalsePositiveFilter> filters, String groupName) {
        this.filters = filters;
        this.groupName = groupName;
    }

    @Override
    public ListMap<String, IndexFinding> createFindings(TokenElementInfo element, ResultT result, List<ShallowEntity> fileEntities, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) throws ConQATException {
        this.createFindingsInGroup(element, result, fileEntities, offsetTransformer, rawLineOffsetConverter);
        return this.findings;
    }

    protected abstract void createFindingsInGroup(TokenElementInfo var1, ResultT var2, List<ShallowEntity> var3, StringOffsetTransformer var4, LineOffsetConverter var5) throws ConQATException;

    protected IndexFinding createFinding(TokenElementInfo element, ControlFlowGraph controlFlowGraph, ControlFlowNode statement, String variable, List<ShallowEntity> fileEntities, TextRegionLocation location) throws ConQATException {
        return this.createFinding(element, controlFlowGraph, statement, variable, fileEntities, location, null);
    }

    protected IndexFinding createFinding(TokenElementInfo element, ControlFlowGraph controlFlowGraph, ControlFlowNode statement, String variable, List<ShallowEntity> fileEntities, TextRegionLocation location, Map<?, ?> variableStates) throws ConQATException {
        if (DataflowFindingsCreatorBase.isFilteredFinding(variable, statement, controlFlowGraph, fileEntities, element, this.filters)) {
            return null;
        }
        IndexFinding finding = new IndexFinding(this.groupName, FINDING_CATEGORY, this.getMessage(variable, statement, element.getLanguage(), variableStates), (ElementLocation)location);
        this.findings.add((Object)location.getUniformPath(), (Object)finding);
        return finding;
    }

    protected static TextRegionLocation getFindingLocation(String variable, TokenElementInfo element, ControlFlowNode statement, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        List<IToken> tokens = statement.getTokens();
        int tokenIndex = TokenStreamTextUtils.findFirst(tokens, (String)variable);
        if (tokenIndex != -1) {
            tokens = Collections.singletonList(tokens.get(tokenIndex));
        } else {
            String[] tokenTexts = variable.split(" ");
            tokenIndex = TokenStreamTextUtils.findSequence(tokens, (String[])tokenTexts);
            if (tokenIndex != -1) {
                tokens = tokens.subList(tokenIndex, tokenIndex + tokenTexts.length);
            }
        }
        return TaintAnalysisUtils.createLocationForTokens(tokens, element, offsetTransformer, rawLineOffsetConverter);
    }

    public static boolean isFilteredFinding(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo element, List<IFalsePositiveFilter> filters) throws ConQATException {
        for (IFalsePositiveFilter filter : filters) {
            if (!filter.isFiltered(variable, statement, cfg, fileEntities, element)) continue;
            return true;
        }
        return false;
    }

    protected abstract String getMessage(String var1, ControlFlowNode var2, ELanguage var3, Map<?, ?> var4);
}

