/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.simulink;

import com.teamscale.index.resource.BinaryElementIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class LazyModelLoader {
    private final BinaryElementIndex binaryElementIndex;
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, SimulinkModel> loadedModels = new HashMap<String, SimulinkModel>();
    private List<String> allKnownElementPaths;

    public LazyModelLoader(BinaryElementIndex binaryElementIndex) {
        this.binaryElementIndex = binaryElementIndex;
    }

    public void preloadModels(List<String> uniformPaths) throws StorageException {
        List<byte[]> content = this.binaryElementIndex.getContents(uniformPaths);
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String uniformPath = uniformPaths.get(i);
            try {
                byte[] bytes = content.get(i);
                if (bytes == null) {
                    throw new SimulinkModelBuildingException(String.format("%s cannot be found.", uniformPath));
                }
                SimulinkModel model = SimulinkUtils.parseModelFromByteArray((byte[])bytes, (String)uniformPath, this::getModelBySimpleName);
                this.loadedModels.put(uniformPath, model);
                continue;
            }
            catch (IOException | SimulinkModelBuildingException e) {
                LOGGER.error("Could not parse model " + uniformPath + ": " + e.getMessage(), e);
                this.loadedModels.put(uniformPath, null);
            }
        }
    }

    public Optional<SimulinkModel> getModelByUniformPath(String uniformPath) throws StorageException {
        if (!this.loadedModels.containsKey(uniformPath)) {
            this.preloadModels(Collections.singletonList(uniformPath));
        }
        return Optional.ofNullable(this.loadedModels.get(uniformPath));
    }

    private SimulinkModel getModelBySimpleName(String name) {
        if (this.allKnownElementPaths == null) {
            try {
                this.allKnownElementPaths = this.binaryElementIndex.getAllElements();
            }
            catch (StorageException e) {
                LOGGER.error("Failed to load all element names: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        CaseInsensitiveStringSet elementNames = new CaseInsensitiveStringSet((Collection)CollectionUtils.asHashSet((Object[])new String[]{name + ".mdl", name + ".slx"}));
        for (String uniformPath : CollectionUtils.filter(this.allKnownElementPaths, arg_0 -> LazyModelLoader.lambda$getModelBySimpleName$0((Set)elementNames, arg_0))) {
            try {
                Optional<SimulinkModel> model = this.getModelByUniformPath(uniformPath);
                if (!model.isPresent()) continue;
                return model.get();
            }
            catch (StorageException e) {
                LOGGER.error("Had storage error while loading model for path " + uniformPath + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getModelBySimpleName$0(Set elementNames, String path) {
        return elementNames.contains(UniformPathUtils.getElementName((String)path));
    }
}

