/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.index.external.input.IntegrateImportedAnalysisResultsTrigger;
import com.teamscale.index.external.input.external_storage.StoreAnalysisResultsInExternalStorageTrigger;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.store.StorageException;

public class DelayedExternalUploadIntegrationTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws StorageException {
        for (InternalProjectId project : this.indexLayer.openProjectIndex().getAllInternalProjectIds()) {
            Collection<String> allSessionIds = ((ExternalAnalysisImportSessionIndex)this.indexLayer.openProjectIndex((IProjectId)project, ExternalAnalysisImportSessionIndex.class, null)).getAllUnscheduledSessionIds();
            if (allSessionIds.isEmpty()) {
                LOGGER.debug("No unscheduled sessions found for project {}", (Object)project);
                continue;
            }
            LOGGER.info("Processing sessions {} for project {}", allSessionIds, (Object)project);
            Lock lock = this.lockProvider.obtainLock(IntegrateImportedAnalysisResultsTrigger.class.getName());
            lock.lock();
            try {
                DurableSet<ScheduledJob> jobQueue = DelayedExternalUploadIntegrationTrigger.getScheduledJobs(this.indexLayer, project);
                ExternalAnalysisImportSessionManager sessionManager = new ExternalAnalysisImportSessionManager(this.indexLayer, project);
                for (String sessionId : allSessionIds) {
                    this.scheduleIntegrationJob(project, sessionManager, sessionId, jobQueue);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void scheduleIntegrationJob(InternalProjectId internalProjectId, ExternalAnalysisImportSessionManager sessionIndex, String sessionId, DurableSet<ScheduledJob> jobQueue) throws StorageException {
        Optional<ExternalAnalysisSessionInfo> session = sessionIndex.getSessionInfo(sessionId);
        if (session.isEmpty()) {
            LOGGER.warn("Session with ID {} not found in session index", (Object)sessionId);
            return;
        }
        if (session.get().isOpen()) {
            LOGGER.error("Integration of open external upload session in project {} with ID {} skipped. Please commit session to enable integration of uploaded data.", (Object)this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)internalProjectId), (Object)sessionId);
            return;
        }
        LOGGER.info("Scheduling integration job for delayed external upload: {}", session);
        if (sessionIndex.markSessionAsScheduled(session.get().getSessionId())) {
            if (session.get().getTargetStorage().isPresent()) {
                StoreAnalysisResultsInExternalStorageTrigger.schedule(internalProjectId, this.indexLayer, "External analysis results were uploaded.");
                return;
            }
            CommitDescriptor schedulingCommit = DelayedExternalUploadIntegrationTrigger.getSchedulingCommit(session.get());
            if (DelayedExternalUploadIntegrationTrigger.isIntegrateTriggerAlreadyScheduled(schedulingCommit, jobQueue)) {
                return;
            }
            JobDescriptor integrationJob = new JobDescriptor(internalProjectId, IntegrateImportedAnalysisResultsTrigger.class, schedulingCommit, "Scheduled to integrate external data for session " + String.valueOf(session.get()));
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.indexLayer, integrationJob);
        }
    }

    private static DurableSet<ScheduledJob> getScheduledJobs(IndexLayer indexLayer, InternalProjectId project) throws StorageException {
        ProjectAnalysisProgressIndex projectProgressIndex = (ProjectAnalysisProgressIndex)indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, indexLayer.resolveProject((IProjectId)project));
        return projectProgressIndex.createJobQueueSet();
    }

    public static boolean isIntegrateTriggerAlreadyScheduled(CommitDescriptor schedulingCommit, IndexLayer indexLayer, InternalProjectId project) throws StorageException {
        return DelayedExternalUploadIntegrationTrigger.getScheduledJobs(indexLayer, project).stream().anyMatch(job -> DelayedExternalUploadIntegrationTrigger.isIntegrateTriggerWithCommit(job, schedulingCommit));
    }

    private static boolean isIntegrateTriggerAlreadyScheduled(CommitDescriptor schedulingCommit, DurableSet<ScheduledJob> jobQueue) {
        return jobQueue.stream().anyMatch(job -> DelayedExternalUploadIntegrationTrigger.isIntegrateTriggerWithCommit(job, schedulingCommit));
    }

    private static boolean isIntegrateTriggerWithCommit(ScheduledJob job, CommitDescriptor schedulingCommit) {
        return IntegrateImportedAnalysisResultsTrigger.class.getName().equals(job.getTriggerName()) && job.getSchedulingCommit().equals((Object)schedulingCommit);
    }

    private static CommitDescriptor getSchedulingCommit(ExternalAnalysisSessionInfo session) {
        return session.getCommit();
    }
}

