/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.commit_clustering;

import com.google.common.collect.Iterables;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitCluster;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ClusterByTimestamp {
    private static final int MOVE_TO_CODE_COMMIT_TOLERANCE_INTERVAL_MILLIS = 500;
    private final Logger logger;
    private final Map<String, ListMap<Long, String>> knownRevisionsByTimestampByBranch;

    @VisibleForTesting
    ClusterByTimestamp(Map<String, ListMap<Long, String>> knownRevisionsByTimestampByBranch, Logger logger) {
        this.knownRevisionsByTimestampByBranch = knownRevisionsByTimestampByBranch;
        this.logger = logger;
    }

    public static ListMap<String, CommitCluster> clusterCommits(ListMap<String, CommitAndPartition> uploadCommits, RepositoryRevisionIndex repositoryRevisionIndex, Logger logger) throws StorageException {
        logger.info("All uploads will be migrated to a cluster of close commits if there are some, otherwise they will be migrated using their current branch and timestamp.");
        return new ClusterByTimestamp(ClusterByTimestamp.getKnownRevisionsByTimestampByBranch(repositoryRevisionIndex, logger), logger).clusterCommits(uploadCommits);
    }

    private static Map<String, ListMap<Long, String>> getKnownRevisionsByTimestampByBranch(RepositoryRevisionIndex repositoryRevisionIndex, Logger logger) throws StorageException {
        logger.traceEntry("Looking up known revisions.", new Supplier[0]);
        PairList<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> allKnownRepositoryRevisions = repositoryRevisionIndex.getAllKnownRepositoryRevisions();
        HashMap<String, ListMap> knownRevisionsByTimestampByBranch = new HashMap<String, ListMap>();
        for (Pair knownRevision : allKnownRepositoryRevisions) {
            if (!knownRevisionsByTimestampByBranch.containsKey(((CommitDescriptor)knownRevision.getFirst()).getBranchName())) {
                knownRevisionsByTimestampByBranch.put(((CommitDescriptor)knownRevision.getFirst()).getBranchName(), new ListMap());
            }
            ListMap revisionsByTimestamp = (ListMap)knownRevisionsByTimestampByBranch.get(((CommitDescriptor)knownRevision.getFirst()).getBranchName());
            revisionsByTimestamp.add((Object)((CommitDescriptor)knownRevision.getFirst()).getTimestamp(), (Object)((RepositoryRevisionIndex.RevisionAndRepository)knownRevision.getSecond()).revision());
        }
        return (Map)logger.traceExit("Found known revisions in branches {}", knownRevisionsByTimestampByBranch);
    }

    @VisibleForTesting
    ListMap<String, CommitCluster> clusterCommits(ListMap<String, CommitAndPartition> uploadCommits) {
        ListMap commitClustersByBranch = new ListMap();
        for (Map.Entry entry : uploadCommits) {
            String branch = (String)entry.getKey();
            List uploadCommitsOnBranch = (List)entry.getValue();
            ListMap<Long, String> revisionsByTimestampOnBranch = this.knownRevisionsByTimestampByBranch.getOrDefault(branch, (ListMap<Long, String>)ListMap.emptyMap());
            Queue sortedUploadCommitsOnBranch = uploadCommitsOnBranch.stream().sorted().collect(Collectors.toCollection(ArrayDeque::new));
            List<Long> sortedCodeTimestampsOnBranch = revisionsByTimestampOnBranch.getKeys().stream().sorted().toList();
            List<CommitCluster> commitClusters = ClusterByTimestamp.clusterCommitsOnBranch(sortedUploadCommitsOnBranch, sortedCodeTimestampsOnBranch, revisionsByTimestampOnBranch);
            commitClustersByBranch.addAll((Object)branch, commitClusters);
            this.logger.trace("Clustered commits for branch {}: {}", (Object)branch, commitClusters);
        }
        return commitClustersByBranch;
    }

    private static List<CommitCluster> clusterCommitsOnBranch(Queue<CommitAndPartition> uploadCommits, List<Long> codeTimestamps, ListMap<Long, String> revisionsByTimestampOnBranch) {
        ListMap commitClusters = new ListMap();
        List<List<CommitAndPartition>> uploadClusters = ClusterByTimestamp.clusterUploads(uploadCommits);
        ListMap<ClusterTarget, CommitAndPartition> target = ClusterByTimestamp.useCodeCommitOrUploadCommitAsTarget(codeTimestamps, uploadClusters, revisionsByTimestampOnBranch);
        commitClusters.addAll(target);
        return commitClusters.entrySet().stream().map(cluster -> new CommitCluster(((ClusterTarget)cluster.getKey()).commit(), ((ClusterTarget)cluster.getKey()).revision(), (List)cluster.getValue())).sorted(Comparator.comparingLong(cluster -> cluster.storageTargetCommit().getTimestamp())).toList();
    }

    private static ListMap<ClusterTarget, CommitAndPartition> useCodeCommitOrUploadCommitAsTarget(List<Long> codeTimestamps, List<List<CommitAndPartition>> uploadClusters, ListMap<Long, String> revisionsByTimestampOnBranch) {
        ListMap commitClusters = new ListMap();
        for (List<CommitAndPartition> uploadCluster : uploadClusters) {
            CommitDescriptor firstUploadCommit = uploadCluster.getFirst().commit();
            long targetTimestamp = ClusterByTimestamp.findTargetTimestamp(codeTimestamps, firstUploadCommit.getTimestamp());
            String revision = ((List)revisionsByTimestampOnBranch.getCollectionOrElse((Object)targetTimestamp, Collections.emptyList())).stream().findFirst().orElse(null);
            CommitDescriptor targetCommit = new CommitDescriptor(firstUploadCommit.getBranchName(), targetTimestamp);
            commitClusters.addAll((Object)new ClusterTarget(targetCommit, revision), uploadCluster);
        }
        return commitClusters;
    }

    private static Long findTargetTimestamp(List<Long> codeTimestamps, long firstUploadCommitTimestamp) {
        long potentialTargetTimestamp = ClusterByTimestamp.findNextSmallestCodeTimestamp(codeTimestamps, firstUploadCommitTimestamp);
        if (ClusterByTimestamp.isOutsideToleranceInterval(potentialTargetTimestamp, firstUploadCommitTimestamp)) {
            return firstUploadCommitTimestamp;
        }
        return potentialTargetTimestamp;
    }

    private static boolean isOutsideToleranceInterval(long codeCommitTimestamp, long uploadCommitTimestamp) {
        return uploadCommitTimestamp - codeCommitTimestamp > 500L;
    }

    @VisibleForTesting
    static long findNextSmallestCodeTimestamp(List<Long> codeTimestamps, long firstUploadTimestamp) {
        if (codeTimestamps.isEmpty() || codeTimestamps.getFirst() > firstUploadTimestamp) {
            return firstUploadTimestamp;
        }
        int index = Collections.binarySearch(codeTimestamps, firstUploadTimestamp);
        int resultIndex = index >= 0 ? index : -index - 2;
        return codeTimestamps.get(resultIndex);
    }

    private static List<List<CommitAndPartition>> clusterUploads(Queue<CommitAndPartition> uploadCommits) {
        ArrayList<List<CommitAndPartition>> clusteredCommits = new ArrayList<List<CommitAndPartition>>();
        while (!uploadCommits.isEmpty()) {
            CommitAndPartition commitDescriptor = uploadCommits.poll();
            ArrayList<CommitAndPartition> cluster = new ArrayList<CommitAndPartition>();
            cluster.add(commitDescriptor);
            while (!uploadCommits.isEmpty() && ClusterByTimestamp.isDirectSuccessor(uploadCommits.peek(), (CommitAndPartition)Iterables.getLast(cluster))) {
                cluster.add(Objects.requireNonNull(uploadCommits.poll(), "Should only be null if the collection was empty."));
            }
            clusteredCommits.add(cluster);
        }
        return clusteredCommits;
    }

    private static boolean isDirectSuccessor(CommitAndPartition successorCandidate, CommitAndPartition predecessorCandidate) {
        return successorCandidate.commit().getTimestamp() == predecessorCandidate.commit().getTimestamp() + 1L;
    }

    private record ClusterTarget(CommitDescriptor commit, @Nullable String revision) {
    }
}

