/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.migrators;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.teamscale.index.external.input.external_storage.migration.StorageBackendMigrationException;
import com.teamscale.index.external.input.external_storage.migration.migrators.IExternalAnalysisResultsMigrator;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultProbeCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.reportparser.model.TeamscaleCompactCoverageReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;

class CoverageMigrator
implements IExternalAnalysisResultsMigrator {
    private static final String COMPACT_COVERAGE_REPORT_FILE_NAME = "compact.coverage";

    CoverageMigrator() {
    }

    @Override
    public ExternalAnalysisImportInfos migrate(ExternalAnalysisResults resultsToMigrate, String path) throws StorageBackendMigrationException {
        List<ExternalAnalysisResultLineCoverage> lineCoverageResult = resultsToMigrate.getByType(ExternalAnalysisResultLineCoverage.class);
        List<ExternalAnalysisResultProbeCoverage> probeCoverageResult = resultsToMigrate.getByType(ExternalAnalysisResultProbeCoverage.class);
        if (!probeCoverageResult.isEmpty() && lineCoverageResult.isEmpty()) {
            throw new StorageBackendMigrationException("Unable to migrate coverage probes, as the associated line coverage information is missing.");
        }
        if (lineCoverageResult.isEmpty()) {
            return new ExternalAnalysisImportInfos();
        }
        LineCoverageInfo lineCoverage = lineCoverageResult.stream().map(ExternalAnalysisResultLineCoverage::getData).reduce(LineCoverageInfo::merge).get();
        ArrayList<TeamscaleCompactCoverageReport.CompactCoverageFileInfo> coverageInfos = new ArrayList<TeamscaleCompactCoverageReport.CompactCoverageFileInfo>();
        List coverageProbes = probeCoverageResult.stream().map(ExternalAnalysisResultProbeCoverage::getData).map(ProbeCoverageInfo::getProbes).flatMap(Collection::stream).toList();
        if (coverageProbes.isEmpty()) {
            coverageProbes = null;
        }
        coverageInfos.add(new TeamscaleCompactCoverageReport.CompactCoverageFileInfo(path, lineCoverage.getFullyCoveredLines(), lineCoverage.getPartiallyCoveredLines(), lineCoverage.getUncoveredLines(), coverageProbes));
        TeamscaleCompactCoverageReport teamscaleCompactCoverageReport = new TeamscaleCompactCoverageReport(Integer.valueOf(1), coverageInfos);
        ExternalAnalysisImportInfoReport.Builder builder = new ExternalAnalysisImportInfoReport.Builder("", EReportFormat.TEAMSCALE_COMPACT_COVERAGE);
        try {
            builder.addReport(COMPACT_COVERAGE_REPORT_FILE_NAME, teamscaleCompactCoverageReport.buildReport());
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new StorageBackendMigrationException(e);
        }
    }

    @Override
    public Set<Class<? extends ExternalAnalysisResult<?>>> getHandledTypes() {
        return Set.of(ExternalAnalysisResultLineCoverage.class, ExternalAnalysisResultProbeCoverage.class);
    }
}

