/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.upload_sessions;

import com.google.common.base.Preconditions;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
@NullMarked
public class ExternalAnalysisSessionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final CommitDescriptor commit;
    private final String username;
    private final String message;
    private final String partition;
    private boolean open = true;
    private final long uploadTimestamp;
    private final @Nullable String revision;
    private final @Nullable String repository;
    private final @Nullable ExternalStorageBackend targetStorage;
    private final boolean isMigrated;
    private long maxReportSize = 0L;

    private ExternalAnalysisSessionInfo(String sessionId, @Nullable ExternalStorageBackend targetStorage, @Nullable String repository, @Nullable String revision, CommitDescriptor commit, String username, String message, String partition, long uploadTimestamp, boolean isMigrated) {
        this.sessionId = sessionId;
        this.targetStorage = targetStorage;
        this.repository = repository;
        this.revision = revision;
        this.commit = commit;
        this.username = username;
        this.message = message;
        this.partition = partition;
        this.uploadTimestamp = uploadTimestamp;
        this.isMigrated = isMigrated;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Optional<ExternalStorageBackend> getTargetStorage() {
        return Optional.ofNullable(this.targetStorage);
    }

    public boolean isMigrated() {
        return this.isMigrated;
    }

    public Optional<String> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    public Optional<String> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public String getUsername() {
        return this.username;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageWithPartition() {
        return "%s (%s)".formatted(this.message, this.partition);
    }

    public String getPartition() {
        return this.partition;
    }

    public boolean isOpen() {
        return this.open;
    }

    public long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public void setCommitted() {
        this.open = false;
    }

    public long getMaxReportSize() {
        return this.maxReportSize;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAnalysisSessionInfo that = (ExternalAnalysisSessionInfo)o;
        return this.open == that.open && this.uploadTimestamp == that.uploadTimestamp && this.maxReportSize == that.maxReportSize && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.commit, that.commit) && Objects.equals(this.username, that.username) && Objects.equals(this.message, that.message) && Objects.equals(this.partition, that.partition) && Objects.equals(this.revision, that.revision) && Objects.equals(this.repository, that.repository) && Objects.equals(this.targetStorage, that.targetStorage) && Objects.equals(this.isMigrated, that.isMigrated);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.commit, this.username, this.message, this.partition, this.open, this.uploadTimestamp, this.revision, this.repository, this.targetStorage, this.maxReportSize, this.isMigrated);
    }

    public void updateMaxReportSize(ExternalAnalysisImportInfos value) {
        for (ExternalAnalysisImportInfoReport reportInfo : value.filterByType(ExternalAnalysisImportInfoReport.class)) {
            this.maxReportSize = Math.max(this.maxReportSize, (long)reportInfo.getData().length());
        }
    }

    public Builder newBuilder() {
        return new Builder().withUploadTimestamp(this.uploadTimestamp).withRepository(this.repository).withPartition(this.partition).withCommit(this.commit).withMessage(this.message).withUsername(this.username).withSessionId(this.sessionId).withTargetStorage(this.targetStorage).withRevision(this.revision);
    }

    public static Builder.SessionIdStage builder() {
        return new Builder().new Builder.SessionIdStage();
    }

    public static class Builder {
        private boolean built = false;
        private @Nullable String sessionId;
        private @Nullable CommitDescriptor commit;
        private @Nullable String revision;
        private @Nullable String repository;
        private @Nullable ExternalStorageBackend targetStorage;
        private @Nullable String username;
        private @Nullable String message;
        private @Nullable String partition;
        private @Nullable Long uploadTimestamp;
        private boolean isMigrated = false;

        private Builder() {
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withCommit(CommitDescriptor commit) {
            this.commit = commit;
            return this;
        }

        public Builder withRevision(@Nullable String revision) {
            this.revision = revision;
            return this;
        }

        public Builder withRepository(@Nullable String repository) {
            this.repository = repository;
            return this;
        }

        public Builder withTargetStorage(@Nullable ExternalStorageBackend targetStorage) {
            this.targetStorage = targetStorage;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withPartition(String partition) {
            this.partition = partition;
            ExternalAnalysisResultIndex.validatePartitionName(partition);
            return this;
        }

        public Builder withUploadTimestamp(long uploadTimestamp) {
            this.uploadTimestamp = uploadTimestamp;
            return this;
        }

        public Builder withIsMigrated(boolean isMigrated) {
            this.isMigrated = isMigrated;
            return this;
        }

        public ExternalAnalysisSessionInfo build() throws IllegalStateException {
            this.ensureOnlyBuiltOnce();
            Preconditions.checkState((this.sessionId != null ? 1 : 0) != 0, (Object)"Session ID must not be null.");
            Preconditions.checkState((this.username != null ? 1 : 0) != 0, (Object)"Username must not be null.");
            Preconditions.checkState((this.message != null ? 1 : 0) != 0, (Object)"Message must not be null.");
            Preconditions.checkState((this.commit != null ? 1 : 0) != 0, (Object)"Commit must not be null.");
            Preconditions.checkState((this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null.");
            Preconditions.checkState((this.uploadTimestamp != null ? 1 : 0) != 0, (Object)"Upload timestamp must not be null.");
            return new ExternalAnalysisSessionInfo(this.sessionId, this.targetStorage, this.repository, this.revision, this.commit, this.username, this.message, this.partition, this.uploadTimestamp, this.isMigrated);
        }

        private void ensureOnlyBuiltOnce() {
            Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"Object was already built.");
            this.built = true;
        }

        public class UploadTimestampStage {
            public Builder withUploadTimestamp(long uploadTimestamp) {
                Builder.this.withUploadTimestamp(uploadTimestamp);
                return Builder.this;
            }
        }

        public class PartitionStage {
            public UploadTimestampStage withPartition(String partition) {
                Builder.this.withPartition(partition);
                return new UploadTimestampStage();
            }
        }

        public class CommitStage {
            public PartitionStage withCommit(CommitDescriptor commit) {
                Builder.this.withCommit(commit);
                return new PartitionStage();
            }
        }

        public class MessageStage {
            public CommitStage withMessage(String message) {
                Builder.this.withMessage(message);
                return new CommitStage();
            }
        }

        public class UserNameStage {
            public MessageStage withUsername(String username) {
                Builder.this.withUsername(username);
                return new MessageStage();
            }
        }

        public class SessionIdStage {
            public UserNameStage withSessionId(String sessionId) {
                Builder.this.withSessionId(sessionId);
                return new UserNameStage();
            }

            public UserNameStage withSessionId(UUID sessionId) {
                return this.withSessionId(sessionId.toString());
            }
        }
    }
}

