/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.configuration.tools.ClangTidyConfiguration;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppIntegratedToolUtils;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import com.teamscale.index.findings.cross_file_analysis.CrossFileFindingsAnalysisBase;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ClangTidySynchronizer
extends CrossFileFindingsAnalysisBase {
    public static final EnumSet<ELanguage> CLANG_TIDY_LANGUAGES = EnumSet.of(ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP);
    public static final Set<String> HEADER_FILE_EXTENSIONS = Set.of("h", "hpp", "hxx", "hh", "inc", "inl");
    public static final String CHECKS_PARAMETER = "checks";
    public static final String ENABLED_CHECKS_FOR_C_REGEX_PARAMETER = "enabled-checks-for-c-regex";
    public static final String ADDITIONAL_ARGS_PARAMETER = "additional-clang-tidy-arguments";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    public static final String FINDING_PARTITION = "clang-tidy";
    public static final String CLANG_TIDY_EXECUTABLE_DEFAULT_NAME = "clang-tidy-21";
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="enabled-checks-for-c-regex")
    private CodeScopeAware<String> enabledChecksForCRegex;
    @StepParameter(value="additional-clang-tidy-arguments")
    private CodeScopeAware<String> additionalArgsParameter;
    @StepParameter(value="check-options")
    private final CodeScopeAware<PairList<String, String>> checkOptions = CodeScopeAware.defaultCodeScopeWithValue((Object)new PairList());
    private static final Logger LOGGER = LogManager.getLogger();
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SystemIncludeFileCacheIndex systemIncludeFileCacheIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CompileCommandIndex compileCommandIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected PathLookupIndex pathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    protected TokenElementIndex contentIndex;
    @DeltaSource(value=BasicTokenElementIndex.class, indexName="basic-token-elements")
    protected KeyDelta basicContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    ReparseRequiredIndex reparseRequiredIndex;
    @DeltaSource(value=CompileCommandIndex.class, indexName="compile-commands")
    protected KeyDelta compileCommandIndexDelta;

    public void execute() throws StorageException {
        try (TemporaryDirectory tmpDir = ClangTidySynchronizer.getTempDirectory((String)"TeamscaleClangTidy");){
            ClangTidySynchronizer.verifyClangTidyVersion();
            List<BasicTokenElementInfo> elementsToAnalyze = this.determinePathsToAnalyze();
            Set<CodeScopeName> relevantCodeScopeNames = CodeScopeUtils.determineRelevantCodeScopeNames(elementsToAnalyze);
            CodeScopeAware<Map<ELanguage, String>> checkSelectorByLanguage = ClangTidySynchronizer.buildCheckSelectorsForCodeScopes(this.selectedChecks, this.enabledChecksForCRegex, relevantCodeScopeNames);
            CodeScopeAware<List<String>> globalCompilerArgumentsPerCodeScope = CppIncludeHandler.determineGlobalCompilerIncludeDirArguments(this.metaIndex, relevantCodeScopeNames);
            ClangTidySynchronizer.addAdditionalArgsPerCodeScope(this.additionalArgsParameter, relevantCodeScopeNames, globalCompilerArgumentsPerCodeScope);
            elementsToAnalyze = ClangTidySynchronizer.filterFilesToAnalyze(elementsToAnalyze, checkSelectorByLanguage);
            SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create(this.metaIndex, this.systemIncludeFileCacheIndex);
            FileIncludeLookup fileIncludeLookup = new FileIncludeLookup(this.pathLookupIndex.createPreloadedLookup(), systemIncludeFileLookup);
            CppIncludeHandler includeHandler = new CppIncludeHandler(this.basicTokenElementIndex, this.compileCommandIndex, fileIncludeLookup, this.getLockProvider());
            ClangTidyRunner runner = new ClangTidyRunner((CodeScopeAware<Map<String, String>>)this.checkOptions.map(PairList::toMap));
            CppToolAnalysisTokenElementDetails tokenElementDetails = CppToolAnalysisTokenElementDetails.loadDetailsForBasicTokenElements(elementsToAnalyze, this.contentIndex);
            Map<String, List<IndexFinding>> findings = runner.prepareAndRunClangTidy(elementsToAnalyze, tmpDir.getPath().toFile(), checkSelectorByLanguage, globalCompilerArgumentsPerCodeScope, false, includeHandler, tokenElementDetails);
            CodeScopeAware analyzedPathsByCodeScope = CodeScopeUtils.groupElementsByCodeScope(elementsToAnalyze).map(elements -> CollectionUtils.mapToSet((Collection)elements, BasicTokenElementInfo::getUniformPath));
            super.storeFindings(findings, (CodeScopeAware<Set<String>>)analyzedPathsByCodeScope, this.basicContentDelta.getDeletedKeysAsStrings(), FINDING_PARTITION);
        }
        catch (IOException | ConQATException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private static void addAdditionalArgsPerCodeScope(CodeScopeAware<String> additionalArgsParameter, Set<CodeScopeName> relevantCodeScopeNames, CodeScopeAware<List<String>> globalCompilerArgumentsPerCodeScope) {
        for (CodeScopeName codeScopeName : relevantCodeScopeNames) {
            String args = (String)additionalArgsParameter.getValueOrNull(codeScopeName);
            if (args == null || args.isEmpty()) continue;
            List globalArgs = (List)globalCompilerArgumentsPerCodeScope.getValue(codeScopeName);
            ArrayList<String> newArgsList = new ArrayList<String>(globalArgs);
            newArgsList.add(args);
            globalCompilerArgumentsPerCodeScope.setValue(codeScopeName, newArgsList);
        }
    }

    private List<BasicTokenElementInfo> determinePathsToAnalyze() throws StorageException {
        HashSet<String> changedKeys = new HashSet<String>(this.basicContentDelta.getAddedOrChangedKeysAsStrings());
        changedKeys.addAll(this.compileCommandIndexDelta.getAddedOrChangedKeysAsStrings());
        if (!CppIntegratedToolUtils.isReanalyzeOnHeaderChangeAnalysisDisabled() && EFeatureToggle.ENABLE_CLANG_TIDY_CPPCHECK_CROSS_FILE_ANALYSIS.isEnabled()) {
            changedKeys.addAll(CppIntegratedToolUtils.determineReanalysisRequiredPaths(this.reparseRequiredIndex, this.getSchedulingCommit()));
            changedKeys.removeIf(path -> HEADER_FILE_EXTENSIONS.contains(FileSystemUtils.getFileExtension((String)path)));
        }
        return this.basicTokenElementIndex.getTokenElements(new ArrayList<String>(changedKeys)).stream().filter(Objects::nonNull).filter(element -> element.getFirstDetailOfType(HiddenTokenElementDetail.class).isEmpty()).toList();
    }

    private static List<BasicTokenElementInfo> filterFilesToAnalyze(List<BasicTokenElementInfo> filesToAnalyze, CodeScopeAware<Map<ELanguage, String>> checkSelectorByLanguage) {
        ArrayList<BasicTokenElementInfo> filteredElements = new ArrayList<BasicTokenElementInfo>();
        for (BasicTokenElementInfo element : filesToAnalyze) {
            String checksForThisElement;
            if (!CLANG_TIDY_LANGUAGES.contains(element.getLanguage()) || (checksForThisElement = (String)((Map)checkSelectorByLanguage.getValue(CodeScopeDetail.getCodeScopeNameFromTokenElement(element))).get(element.getLanguage())) == null || checksForThisElement.isEmpty()) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    public static CodeScopeAware<Map<ELanguage, String>> buildCheckSelectorsForCodeScopes(CodeScopeAware<List<String>> selectedChecks, CodeScopeAware<String> enabledChecksForCRegex, Set<CodeScopeName> relevantCodeScopeNames) {
        CodeScopeAware checkSelectorsForCodeScopes = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : selectedChecks.getCodeScopeNames()) {
            String check2;
            if (!relevantCodeScopeNames.contains(codeScopeName)) continue;
            ListMap checksByLanguage = new ListMap();
            for (String check2 : (List)selectedChecks.getValue(codeScopeName)) {
                for (ELanguage language : ClangTidyConfiguration.determineCheckLanguages(check2)) {
                    checksByLanguage.add((Object)language, (Object)check2);
                }
            }
            HashMap<ELanguage, String> checkSelectorByLanguage = new HashMap<ELanguage, String>();
            check2 = checksByLanguage.getKeys().iterator();
            while (check2.hasNext()) {
                ELanguage language = (ELanguage)check2.next();
                checkSelectorByLanguage.put(language, StringUtils.concat((Iterable)checksByLanguage.getCollection((Object)language), (String)","));
            }
            String cppChecks = checkSelectorByLanguage.getOrDefault(ELanguage.CPP, "");
            if (cppChecks.isEmpty()) {
                cppChecks = checkSelectorByLanguage.getOrDefault(ELanguage.CPP_MS_CLI, "");
            }
            String enabledChecksForC = ClangTidySynchronizer.filterChecksByRegex(cppChecks, (String)enabledChecksForCRegex.getValueWithDefault(codeScopeName));
            checkSelectorByLanguage.put(ELanguage.C, enabledChecksForC);
            checkSelectorsForCodeScopes.setValue(codeScopeName, checkSelectorByLanguage);
        }
        return checkSelectorsForCodeScopes;
    }

    public static String filterChecksByRegex(String selectedChecks, String regex) {
        if (selectedChecks == null) {
            return "";
        }
        if (regex == null) {
            return selectedChecks;
        }
        String[] checks = selectedChecks.split(",");
        return Arrays.stream(checks).filter(check -> check.matches(regex)).collect(Collectors.joining(","));
    }

    public static void verifyClangTidyVersion() throws ConQATException {
        String expectedVersion = ClangTidySynchronizer.loadExpectedClangTidyVersion();
        Pair<Integer, String> actualVersion = ClangTidyRunner.determineClangTidyVersion();
        if (actualVersion.getSecond() == null || !((String)actualVersion.getSecond()).contains(expectedVersion)) {
            throw new ConQATException("No clang-tidy or wrong version. Required version " + expectedVersion + " Return Code: " + String.valueOf(actualVersion.getFirst()) + " Output: " + (String)actualVersion.getSecond());
        }
    }

    public static String loadExpectedClangTidyVersion() {
        String content = Resource.of(ClangTidyConfiguration.class, (String)"clang-tidy/version.txt").getContent();
        Object expectedVersion = "";
        for (String line : StringUtils.splitLines((String)content)) {
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (!((String)expectedVersion).isEmpty()) {
                expectedVersion = (String)expectedVersion + "\n";
            }
            expectedVersion = (String)expectedVersion + line.trim();
        }
        return expectedVersion;
    }
}

