/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.index.findings.kubescore.KubernetesManifestBuilder;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;

public class KustomizationBuilder
extends KubernetesManifestBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern COMMA_SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
    private final String kustomizationPath;
    private final List<String> affectedFiles;

    public KustomizationBuilder(TokenElementIndex contentIndex, CommitDescriptor schedulingCommit, String kustomizationPath, Set<String> affectedFiles) {
        super(contentIndex, schedulingCommit);
        this.kustomizationPath = kustomizationPath;
        this.affectedFiles = new ArrayList<String>(affectedFiles);
    }

    @Override
    public String build() throws ConQATException {
        PairList<String, TokenElementInfo> affectedSourceFilesWithTokenElements = this.initializeAffectedFilesWithTokenElementsAndValidate();
        if (affectedSourceFilesWithTokenElements == null) {
            return "";
        }
        return this.getManifestFromKustomization(affectedSourceFilesWithTokenElements);
    }

    private PairList<String, TokenElementInfo> initializeAffectedFilesWithTokenElementsAndValidate() throws StorageException {
        PairList affectedSourceFilesWithTokenElements = new PairList();
        List<TokenElementInfo> affectedSourceTokenElements = this.contentIndex.getTokenElements(this.affectedFiles);
        for (int i = 0; i < this.affectedFiles.size(); ++i) {
            TokenElementInfo tokenElement = affectedSourceTokenElements.get(i);
            if (tokenElement == null) {
                this.parseLogEntries.add(KubernetesUtils.createParseLogEntry("Source '" + this.affectedFiles.get(i) + "' does not exist in the project's analysis scope. Skipping analysis for this kustomization.yaml.", this.kustomizationPath, this.schedulingCommit));
                return null;
            }
            affectedSourceFilesWithTokenElements.add((Object)this.affectedFiles.get(i), (Object)tokenElement);
        }
        return affectedSourceFilesWithTokenElements;
    }

    private String getManifestFromKustomization(PairList<String, TokenElementInfo> affectedFilesWithTokenElements) throws ConQATException {
        String string;
        block9: {
            TemporaryDirectory tempDirectory = FileSystemUtils.getTemporaryDirectory((String)"kubernetes");
            try {
                String tempPath = tempDirectory.getPath().toString();
                this.patchBuildMetadataAndCreateTemporaryFiles(tempPath, affectedFilesWithTokenElements);
                String tempPathKustomizationDirectory = UniformPathUtils.concatenate((String[])new String[]{tempPath, UniformPathUtils.getParentPath((String)this.kustomizationPath)});
                List<String> kustomizeCommand = KustomizationBuilder.getKustomizeCommand(tempPathKustomizationDirectory);
                ProcessUtils.ExecutionResult result = KubernetesUtils.executeKubernetesProcess(kustomizeCommand);
                String error = result.getStderr();
                String stdout = result.getStdout();
                if (!error.isEmpty()) {
                    this.logManifestBuildError(LOGGER, stdout, error, this.kustomizationPath);
                }
                string = stdout;
                if (tempDirectory == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tempDirectory != null) {
                        try {
                            tempDirectory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConQATException(e.getMessage(), (Throwable)e);
                }
            }
            tempDirectory.close();
        }
        return string;
    }

    private void patchBuildMetadataAndCreateTemporaryFiles(String tempDirectory, PairList<String, TokenElementInfo> affectedFilesWithTokenElements) throws IOException, StorageException {
        TokenElementInfo rootKustomizationTokenElement = this.contentIndex.getTokenElement(this.kustomizationPath);
        String text = KustomizationBuilder.getPatchedKustomizationContent(rootKustomizationTokenElement);
        FileSystemUtils.createFileRelativeToBaseDirectory((String)tempDirectory, (String)this.kustomizationPath, (String)text);
        for (Pair affectedFileWithTokenElement : affectedFilesWithTokenElements) {
            TokenElementInfo tokenElement = (TokenElementInfo)((Object)affectedFileWithTokenElement.getSecond());
            CCSMAssert.isNotNull((Object)((Object)tokenElement), (String)("It should have been verified beforehand that the token element is not null: " + (String)affectedFileWithTokenElement.getFirst()));
            FileSystemUtils.createFileRelativeToBaseDirectory((String)tempDirectory, (String)tokenElement.getUniformPath(), (String)tokenElement.getText());
        }
    }

    private static String getPatchedKustomizationContent(TokenElementInfo tokenElementInfo) {
        String fullBuildMetadata = "buildMetadata: [originAnnotations]";
        String text = tokenElementInfo.getText();
        int posBuildMetadata = text.indexOf("buildMetadata:");
        if (posBuildMetadata == -1) {
            return text + "\n" + fullBuildMetadata;
        }
        int posOpeningBracket = text.indexOf(91, posBuildMetadata);
        int posClosingBracket = text.indexOf(93, posBuildMetadata);
        if (posOpeningBracket == -1 || posClosingBracket == -1) {
            LOGGER.warn("Found 'buildMetadata:' but no brackets '[]'. See content: {}", (Object)text);
            text = StringUtils.normalizeLineSeparatorsPlatformIndependent((String)text);
            int posNextLineBreak = text.indexOf("\n", posBuildMetadata);
            return text.substring(0, posBuildMetadata) + fullBuildMetadata + text.substring(posNextLineBreak);
        }
        return KustomizationBuilder.ensureAnnotationsArePresent(text, posOpeningBracket, posClosingBracket);
    }

    private static List<String> getKustomizeCommand(String kustomizationDirectory) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(KubernetesUtils.loadConfiguredKustomizeExe());
        command.add("build");
        command.add(kustomizationDirectory);
        return command;
    }

    private static String ensureAnnotationsArePresent(String text, int posOpeningBracket, int posClosingBracket) {
        String trimmedText = text.substring(posOpeningBracket + 1, posClosingBracket).trim();
        String[] options = COMMA_SPLIT_PATTERN.split(trimmedText);
        TreeSet<String> existingOptions = options.length == 1 && options[0].isEmpty() ? new TreeSet() : new TreeSet<String>(Arrays.asList(options));
        existingOptions.add("originAnnotations");
        return text.substring(0, posOpeningBracket + 1) + String.join((CharSequence)",", existingOptions) + text.substring(posClosingBracket);
    }
}

