/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.requirements_tracing.merge_request.ImpactedSpecItemsDelta;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.tracking.FindingChurnList;
import java.io.Serializable;
import java.util.Optional;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="merge-request-delta", options={EStorageOption.NO_ROLLBACK}, valueClasses={MergeRequestDelta.class})
public class MergeRequestDeltaIndex
extends IndexBase
implements IProjectIndex {
    public static final String NAME = "merge-request-delta";

    public MergeRequestDeltaIndex(IStore store) {
        super(store);
    }

    public Optional<MergeRequestDelta> getDelta(MergeRequestIdentifier identifier) throws StorageException {
        byte[] value = this.store.getWithString(MergeRequestDeltaIndex.createMergeRequestIdentifierKey(identifier));
        return Optional.ofNullable((MergeRequestDelta)StorageUtils.deserialize((byte[])value));
    }

    public void updateDelta(MergeRequestIdentifier identifier, @Nullable MergeBaseInfo mergeBase, FindingChurnList findingChurnList, int numberOfPendingExclusions, ImpactedSpecItemsDelta impactedSpecItemsDelta, @Nullable CounterSet<ETestGapState> testGapStates, @Nullable MergeRequestCriticalChangeInfo mergeRequestCriticalChangeInfo) throws StorageException {
        this.store.putWithString(MergeRequestDeltaIndex.createMergeRequestIdentifierKey(identifier), StorageUtils.serialize((Serializable)new MergeRequestDelta(mergeBase, findingChurnList, numberOfPendingExclusions, impactedSpecItemsDelta, testGapStates, mergeRequestCriticalChangeInfo)));
    }

    private static String createMergeRequestIdentifierKey(MergeRequestIdentifier identifier) {
        return identifier.toString().toLowerCase();
    }

    @IndexValueClass
    public record MergeRequestDelta(@Nullable MergeBaseInfo mergeBase, FindingChurnList findingChurnList, int numberOfPendingExclusions, ImpactedSpecItemsDelta impactedSpecItemsDelta, @Nullable CounterSet<ETestGapState> testGapStates, @Nullable MergeRequestCriticalChangeInfo criticalChangeInfo) implements Serializable
    {
    }
}

