/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.critical_changes;

import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfigurationEntry;
import com.teamscale.index.findings.calculation.TokenElementChurnInfo;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.merge_request.MergeRequestChangedMethod;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChange;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeInfo;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeLocation;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MergeRequestCriticalChangeMatcher {
    private static final String METHOD_NAME_SEPARATOR = "#";
    private final List<CriticalChangeBadgesConfigurationEntry> configuredCriticalBadges;
    private final List<MergeRequestChangedMethod> changedMethods;
    private final List<String> changedFilesPaths;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private final RepositoryLogIndex repositoryLogIndex;
    private final MergeBaseInfo mergeBase;
    private final ProjectStorageSystem projectStorageSystem;

    public MergeRequestCriticalChangeMatcher(List<CriticalChangeBadgesConfigurationEntry> configuredCriticalBadges, List<String> changedFilesPaths, List<MergeRequestChangedMethod> changedMethods, RepositoryLogIndex repositoryLogIndex, ProjectStorageSystem projectStorageSystem, CommitDescriptor sourceCommit, MergeBaseInfo mergeBase) throws StorageException {
        this.configuredCriticalBadges = configuredCriticalBadges;
        this.changedMethods = changedMethods;
        this.changedFilesPaths = changedFilesPaths;
        this.projectStorageSystem = projectStorageSystem;
        this.mergeBase = mergeBase;
        this.repositoryLogIndex = repositoryLogIndex;
        this.tokenElementLineInfoIndex = (TokenElementLineInfoIndex)projectStorageSystem.openProjectIndex(TokenElementLineInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)sourceCommit));
    }

    private Map<String, UniformPath> buildUniformPathToOriginPathMap() throws StorageException {
        if (this.mergeBase == null) {
            return Collections.emptyMap();
        }
        List<CommitDescriptor> relevantCommits = MergeRequestUtils.determineRelevantCommitsInMergeRequest(this.repositoryLogIndex, this.mergeBase);
        if (relevantCommits.isEmpty()) {
            return Collections.emptyMap();
        }
        List<TokenElementChurnWithOriginInfo> changedFiles = MergeRequestUtils.getMergeRequestAffectedCodeFiles(this.mergeBase, this.repositoryLogIndex, this.projectStorageSystem);
        return changedFiles.stream().filter(info -> info.getOriginPath() != null).collect(Collectors.toMap(TokenElementChurnInfo::getUniformPath, info -> UniformPath.parse((String)info.getOriginPath())));
    }

    public MergeRequestCriticalChangeInfo findCriticalChanges() throws StorageException {
        HashSet<MergeRequestCriticalChange> matchedCriticalChanges = new HashSet<MergeRequestCriticalChange>();
        Map<String, UniformPath> uniformPathToOriginPathMap = this.buildUniformPathToOriginPathMap();
        for (CriticalChangeBadgesConfigurationEntry configuredBadge : this.configuredCriticalBadges) {
            List<MergeRequestCriticalChangeLocation> matchedLocations = this.findMatchingMethods(configuredBadge.criticalChangeRegexes(), uniformPathToOriginPathMap);
            matchedLocations.addAll(this.findMatchingFiles(configuredBadge.criticalChangeRegexes(), uniformPathToOriginPathMap));
            this.setLineRangesForMethodLocations(matchedLocations);
            if (matchedLocations.isEmpty()) continue;
            matchedCriticalChanges.add(new MergeRequestCriticalChange(configuredBadge, matchedLocations));
        }
        return new MergeRequestCriticalChangeInfo(matchedCriticalChanges);
    }

    private void setLineRangesForMethodLocations(List<MergeRequestCriticalChangeLocation> matchedLocations) throws StorageException {
        Set methodFilePaths = CollectionUtils.mapToSet(matchedLocations, location -> location.getUniformPath().toString());
        if (methodFilePaths.isEmpty()) {
            return;
        }
        Map<String, TokenElementLineInfo> byPath = this.tokenElementLineInfoIndex.getLineInfosByPaths(methodFilePaths);
        for (MergeRequestCriticalChangeLocation location2 : matchedLocations) {
            TokenElementLineInfo info;
            if (!location2.isMethodLocation() || (info = byPath.get(location2.getUniformPath().toString())) == null) continue;
            location2.setMethodLineRange(info.getRawLineOffsetConverter());
        }
    }

    private List<MergeRequestCriticalChangeLocation> findMatchingFiles(List<String> criticalChangeRegexes, Map<String, UniformPath> uniformPathToOriginPathMap) {
        IncludeExcludeRegexSupport fileRegexes = new IncludeExcludeRegexSupport(criticalChangeRegexes.stream().filter(regex -> !regex.contains(METHOD_NAME_SEPARATOR)).toList(), Collections.emptyList());
        if (fileRegexes.getIncludePatterns().isEmpty()) {
            return new ArrayList<MergeRequestCriticalChangeLocation>();
        }
        return this.changedFilesPaths.stream().distinct().filter(arg_0 -> ((IncludeExcludeRegexSupport)fileRegexes).isIncluded(arg_0)).map(UniformPath::parse).map(path -> MergeRequestCriticalChangeLocation.forChangedFile(path, (UniformPath)uniformPathToOriginPathMap.get(path.toString()))).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<MergeRequestCriticalChangeLocation> findMatchingMethods(List<String> criticalChangeRegexes, Map<String, UniformPath> uniformPathToOriginPathMap) {
        List<String> methodRegexes = criticalChangeRegexes.stream().filter(regex -> regex.contains(METHOD_NAME_SEPARATOR)).toList();
        if (methodRegexes.isEmpty()) {
            return new ArrayList<MergeRequestCriticalChangeLocation>();
        }
        ArrayList<String> filePathRegexParts = new ArrayList<String>();
        ArrayList<String> methodNameRegexParts = new ArrayList<String>();
        for (String methodRegex : methodRegexes) {
            String[] split = methodRegex.split(METHOD_NAME_SEPARATOR);
            CCSMAssert.isTrue((split.length > 1 ? 1 : 0) != 0, (String)("Cannot happen. We filter for regexes that have the separator. Mismatching regex: " + methodRegex));
            filePathRegexParts.add(split[0]);
            methodNameRegexParts.add(Arrays.stream(split).skip(1L).reduce("", String::concat));
        }
        IncludeExcludeRegexSupport filePathRegexSupport = new IncludeExcludeRegexSupport(filePathRegexParts, Collections.emptyList());
        IncludeExcludeRegexSupport methodNameRegexSupport = new IncludeExcludeRegexSupport(methodNameRegexParts, Collections.emptyList());
        return CollectionUtils.filterAndMap(this.changedMethods, method -> filePathRegexSupport.isIncluded(method.getFilePath().toString()) && methodNameRegexSupport.isIncluded(method.methodName()), method -> MergeRequestCriticalChangeLocation.forChangedMethod(method, (UniformPath)uniformPathToOriginPathMap.get(method.getFilePath().toString())));
    }
}

