/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.voting;

import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.model.snapshots.Unit;
import java.time.Duration;
import java.util.Arrays;

public class PrometheusVotingTimeHistogram {
    public static final Histogram INSTANCE = PrometheusVotingTimeHistogram.registerHistogram();

    private PrometheusVotingTimeHistogram() {
    }

    private static Histogram registerHistogram() {
        Histogram.Builder histogramBuilder = Histogram.builder();
        histogramBuilder.name("voting_time_seconds");
        histogramBuilder.help("Time it took to vote on a merge request");
        histogramBuilder.labelNames(new String[]{"project", "state"});
        histogramBuilder.unit(Unit.SECONDS);
        histogramBuilder.classicUpperBounds(PrometheusVotingTimeHistogram.durationToSeconds(Duration.ofSeconds(10L), Duration.ofSeconds(30L), Duration.ofMinutes(1L), Duration.ofMinutes(5L), Duration.ofMinutes(10L), Duration.ofMinutes(30L), Duration.ofHours(1L), Duration.ofHours(2L), Duration.ofHours(4L), Duration.ofHours(8L)));
        return (Histogram)histogramBuilder.register();
    }

    private static double[] durationToSeconds(Duration ... durations) {
        return Arrays.stream(durations).mapToDouble(Duration::toSeconds).toArray();
    }
}

