/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.threshold;

import org.conqat.lib.commons.assertion.CCSMAssert;

class PathMatchResult {
    public static final PathMatchResult PERFECT_MATCH = new PathMatchResult(true, 0);
    public static final PathMatchResult NO_MATCH = new PathMatchResult(false, -1);
    private final boolean isMatch;
    private final int unmatchedPathLevelCount;

    private PathMatchResult(boolean isMatch, int unmatchedPathLevelCount) {
        this.isMatch = isMatch;
        this.unmatchedPathLevelCount = unmatchedPathLevelCount;
    }

    public static PathMatchResult partialMatch(int value) {
        CCSMAssert.isTrue((value > 0 ? 1 : 0) != 0, (String)"Value must be > 0");
        return new PathMatchResult(true, value);
    }

    public boolean isMatch() {
        return this.isMatch;
    }

    public boolean isBetterThan(PathMatchResult otherMatchResult) {
        if (this == otherMatchResult) {
            return false;
        }
        if (this == PERFECT_MATCH || otherMatchResult == NO_MATCH) {
            return true;
        }
        if (this == NO_MATCH || otherMatchResult == PERFECT_MATCH) {
            return false;
        }
        return this.unmatchedPathLevelCount < otherMatchResult.unmatchedPathLevelCount;
    }

    public int hashCode() {
        return this.unmatchedPathLevelCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathMatchResult) {
            return this.unmatchedPathLevelCount == ((PathMatchResult)obj).unmatchedPathLevelCount;
        }
        return false;
    }
}

