/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion37NonBranchedModeMigration {
    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion37NonBranchedModeMigration::addNonBranchedNodeToTfsConnectors);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration addNonBranchedNodeToTfsConnectors(ConnectorConfiguration connectorConfiguration) {
        if (!connectorConfiguration.getRawType().equals(ERepositoryConnector.TFS.getReadableName())) {
            return connectorConfiguration;
        }
        boolean branchingEnabled = "true".equals(connectorConfiguration.getOptionValue("Enable branch analysis"));
        String nonBranchedMode = "true";
        if (branchingEnabled) {
            nonBranchedMode = "false";
        }
        connectorConfiguration.setOptionValue("Non-branched mode", nonBranchedMode);
        return connectorConfiguration;
    }
}

