/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion48RenameBitbucketServerCommentMechanismOptions {
    private static final String OLD_PULL_REQUEST_COMMENTS_OPTION_NAME = "Add Detailed Line Comments For Findings as Pull Request Comments";
    private static final String OLD_CODE_INSIGHTS_REPORT_COMMENTS_OPTION_NAME = "Add Detailed Line Comments For Findings as Code Insights Report";
    private static final String NEW_PULL_REQUEST_COMMENTS_OPTION_NAME = "Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments";
    private static final String NEW_CODE_INSIGHTS_REPORT_COMMENTS_OPTION_NAME = "Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report";
    private static final boolean PULL_REQUEST_COMMENTS_DEFAULT = false;
    private static final boolean CODE_INSIGHTS_REPORT_COMMENTS_DEFAULT = true;
    private static final String BITBUCKET_SERVER_CONNECTOR_TYPE = "Bitbucket Server (On-Premise)";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion48RenameBitbucketServerCommentMechanismOptions::migrateConnectorConfiguration);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateConnectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        if (BITBUCKET_SERVER_CONNECTOR_TYPE.equals(connectorConfiguration.getRawType())) {
            connectorConfiguration.setOptionValue(NEW_PULL_REQUEST_COMMENTS_OPTION_NAME, Optional.ofNullable(connectorConfiguration.getOptionValue(OLD_PULL_REQUEST_COMMENTS_OPTION_NAME)).orElse(Boolean.toString(false)));
            connectorConfiguration.setOptionValue(NEW_CODE_INSIGHTS_REPORT_COMMENTS_OPTION_NAME, Optional.ofNullable(connectorConfiguration.getOptionValue(OLD_CODE_INSIGHTS_REPORT_COMMENTS_OPTION_NAME)).orElse(Boolean.toString(true)));
            connectorConfiguration.removeOptions(Set.of(OLD_PULL_REQUEST_COMMENTS_OPTION_NAME, OLD_CODE_INSIGHTS_REPORT_COMMENTS_OPTION_NAME));
        }
        return connectorConfiguration;
    }
}

