/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.monitoring.prometheus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.monitoring.prometheus.PrometheusMetricsUploader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="prometheus-push-metrics", name="Push Prometheus Metrics", type=EOptionType.SERVER, category=EOptionCategory.MONITORING, orderingHint=200)
@IndexValueClass(containedInBackup=true)
public class PrometheusPushMetricsOption
implements IOption {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "prometheus-push-metrics";
    public static final String OPTION_NAME = "Push Prometheus Metrics";
    private static final String PROMETHEUS_PUSH_SECRET_PRODUCTION_OPTION_NAME = "Secret used when transmitting metrics to the configured production endpoint. The secret will be used in a Bearer Authentication header.";
    private static final String PROMETHEUS_PUSH_SECRET_STAGING_OPTION_NAME = "Secret used when transmitting metrics to the configured staging endpoint. The secret will be used in a Bearer Authentication header.";
    private static final String PROMETHEUS_PUSH_SCHEDULE_OPTION_NAME = "How often to transmit updates if the option above is enabled. Usually a low value like once per minute.";
    private static final String PROMETHEUS_PUSH_URL_PRODUCTION_OPTION_DESCRIPTION = "URL of the webserver to which to send metrics when this Teamscale instance *is not* in shadow mode.";
    private static final String PROMETHEUS_PUSH_URL_STAGING_OPTION_DESCRIPTION = "URL of the webserver to which to send metrics when this Teamscale instance *is* in shadow mode.";
    private static final String PROMETHEUS_PUSH_METRICS_OPTION_DESCRIPTION = "This requires an outbound connection to the configured URL. Administrators might find this helpful to configure monitoring in cases where Prometheus can not reach Teamscale.";
    @JsonProperty(value="pushPrometheusMetrics")
    @OptionFieldDescription(name="Regularly transmit Prometheus metrics to a webserver", description="This requires an outbound connection to the configured URL. Administrators might find this helpful to configure monitoring in cases where Prometheus can not reach Teamscale.", dependentOptions={"pushSecretProduction", "transmissionSchedule", "productionUrl", "enableDifferentServerForStaging"})
    public boolean pushPrometheusMetrics = false;
    @JsonProperty(value="transmissionSchedule")
    @OptionFieldDescription(name="How often to transmit updates if the option above is enabled. Usually a low value like once per minute.")
    @ScheduleOption(runnableClass=PrometheusMetricsUploader.class, enablementOption="pushPrometheusMetrics")
    public String transmissionSchedule = "* * * * *";
    @JsonProperty(value="productionUrl")
    @OptionFieldDescription(name="URL for production metrics", description="URL of the webserver to which to send metrics when this Teamscale instance *is not* in shadow mode.")
    public String productionUrl = null;
    @JsonProperty(value="pushSecretProduction")
    @OptionFieldDescription(name="Secret used when transmitting metrics to the configured production endpoint. The secret will be used in a Bearer Authentication header.")
    @PasswordOption
    public String pushSecretProduction = null;
    @JsonProperty(value="enableDifferentServerForStaging")
    @OptionFieldDescription(name="Send monitoring data to different webserver if this Teamscale instance is in shadow mode.", description="This requires an outbound connection to the configured URL. Administrators might find this helpful to configure monitoring in cases where Prometheus can not reach Teamscale.", dependentOptions={"pushSecretStaging", "stagingUrl"})
    public boolean enableDifferentServerForStaging = false;
    @JsonProperty(value="stagingUrl")
    @OptionFieldDescription(name="URL for staging metrics", description="URL of the webserver to which to send metrics when this Teamscale instance *is* in shadow mode.")
    public String stagingUrl = null;
    @JsonProperty(value="pushSecretStaging")
    @OptionFieldDescription(name="Secret used when transmitting metrics to the configured staging endpoint. The secret will be used in a Bearer Authentication header.")
    @PasswordOption
    public String pushSecretStaging = null;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (!this.pushPrometheusMetrics) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.transmissionSchedule)) {
            return "Please enter a valid cron expression as transmission schedule.";
        }
        if (StringUtils.isEmpty((String)this.productionUrl)) {
            return "Please enter a valid URL to push metrics to.";
        }
        try {
            PrometheusMetricsUploader.sendMetrics(this, (ServerOptionIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class));
        }
        catch (ServiceCallException e) {
            String message = "Error sending Prometheus metrics: " + e.getMessage();
            LOGGER.error(message, (Throwable)e);
            return message + "\nSee log for details";
        }
        if (!this.enableDifferentServerForStaging) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.stagingUrl)) {
            return "Please enter a valid URL to push metrics of staging instances to.";
        }
        return null;
    }
}

