/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.index.naming.ENamingConventionTokenClass;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class NamingConventionGroup {
    private final String uiStringSingular;
    private final String uiStringPlural;
    private final String findingMessagePrefix;
    public final ENamingConventionTokenClass tokenClass;

    private NamingConventionGroup(ENamingConventionTokenClass tokenClass, String uiStringSingular) {
        this(tokenClass, uiStringSingular, uiStringSingular + "s");
    }

    private NamingConventionGroup(ENamingConventionTokenClass tokenClass, String uiStringSingular, String uiStringPlural) {
        this(tokenClass, uiStringSingular, uiStringPlural, uiStringSingular);
    }

    private NamingConventionGroup(ENamingConventionTokenClass tokenClass, String uiStringSingular, String uiStringPlural, String findingMessagePrefix) {
        this.tokenClass = tokenClass;
        this.uiStringSingular = uiStringSingular;
        this.uiStringPlural = uiStringPlural;
        this.findingMessagePrefix = findingMessagePrefix;
    }

    public static NamingConventionGroup create(ELanguage language, ENamingConventionTokenClass namingConventionTokenClass) {
        return switch (namingConventionTokenClass) {
            default -> throw new MatchException(null, null);
            case ENamingConventionTokenClass.MODULES -> NamingConventionGroup.createForModules(language, namingConventionTokenClass);
            case ENamingConventionTokenClass.TYPES -> NamingConventionGroup.createForTypes(language, namingConventionTokenClass);
            case ENamingConventionTokenClass.METHODS -> NamingConventionGroup.createForMethods(language, namingConventionTokenClass);
            case ENamingConventionTokenClass.METHOD_PARAMETERS -> NamingConventionGroup.createForMethodParameters(language, namingConventionTokenClass);
            case ENamingConventionTokenClass.ATTRIBUTES -> new NamingConventionGroup(namingConventionTokenClass, "attribute");
            case ENamingConventionTokenClass.GLOBAL_VARIABLES -> new NamingConventionGroup(namingConventionTokenClass, "global variable");
            case ENamingConventionTokenClass.LOCAL_VARIABLES -> NamingConventionGroup.createForLocalVariables(language, namingConventionTokenClass);
            case ENamingConventionTokenClass.CONSTANTS -> {
                if (LanguageGroups.C_AND_DERIVATIVES.contains(language)) {
                    yield new NamingConventionGroup(namingConventionTokenClass, "global constant");
                }
                yield new NamingConventionGroup(namingConventionTokenClass, "constant");
            }
            case ENamingConventionTokenClass.FUNCTIONAL_COMPONENTS -> new NamingConventionGroup(namingConventionTokenClass, "functional component");
        };
    }

    private static @NonNull NamingConventionGroup createForLocalVariables(ELanguage language, ENamingConventionTokenClass namingConventionTokenClass) {
        if (language == ELanguage.PHP) {
            return new NamingConventionGroup(namingConventionTokenClass, "property", "properties");
        }
        return new NamingConventionGroup(namingConventionTokenClass, "local variable");
    }

    private static @NonNull NamingConventionGroup createForTypes(ELanguage language, ENamingConventionTokenClass namingConventionTokenClass) {
        if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language)) {
            return new NamingConventionGroup(namingConventionTokenClass, "classes and structs", "classes and structs", "class/struct");
        }
        return new NamingConventionGroup(namingConventionTokenClass, "class", "classes");
    }

    private static @NonNull NamingConventionGroup createForModules(ELanguage language, ENamingConventionTokenClass namingConventionTokenClass) {
        return switch (language) {
            case ELanguage.OSCRIPT -> new NamingConventionGroup(namingConventionTokenClass, "package");
            case ELanguage.JAVA, ELanguage.GOSU -> new NamingConventionGroup(namingConventionTokenClass, "Package");
            default -> new NamingConventionGroup(namingConventionTokenClass, "namespace");
        };
    }

    private static @NonNull NamingConventionGroup createForMethods(ELanguage language, ENamingConventionTokenClass namingConventionTokenClass) {
        return switch (language) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.PHP -> new NamingConventionGroup(namingConventionTokenClass, "functions and methods", "functions and methods", "function/method");
            case ELanguage.JAVASCRIPT -> new NamingConventionGroup(namingConventionTokenClass, "function");
            default -> new NamingConventionGroup(namingConventionTokenClass, "method");
        };
    }

    private static @NonNull NamingConventionGroup createForMethodParameters(ELanguage language, ENamingConventionTokenClass namingConventionTokenClass) {
        return switch (language) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> new NamingConventionGroup(namingConventionTokenClass, "function and method parameter", "function and method parameters", "function/method parameter");
            case ELanguage.PHP, ELanguage.JAVASCRIPT -> new NamingConventionGroup(namingConventionTokenClass, "function parameter");
            default -> new NamingConventionGroup(namingConventionTokenClass, "method parameter");
        };
    }

    public String getReadableName() {
        return StringUtils.capitalize((String)this.uiStringSingular);
    }

    public String getFindingMessagePrefix() {
        return StringUtils.capitalize((String)this.findingMessagePrefix);
    }

    public String getUiStringPlural() {
        return this.uiStringPlural;
    }
}

