/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.external.update.ExternalUploadPersisterBase;
import com.teamscale.index.precommit.PreCommitUploadCommit;
import com.teamscale.index.precommit.PreCommitUploadStagingIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryContentUpdaterCodeScopeSupport;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ambiguous_language.AmbiguousLanguageResolutionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

public class PreCommitUploadPersister
extends ExternalUploadPersisterBase<PreCommitUploadCommit> {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private BasicTokenElementIndex basicElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProjectRepositoryChangeIndex projectRepositoryChangeIndex;
    @BranchingLayerAccess(value=PreCommitUploadStagingIndex.class)
    private IBranchingLayer preCommitUploadStagingBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="precommit-commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @DeltaSource(value=CommitTreeIndex.class, indexName="precommit-commit-tree")
    private KeyDelta commitTreeDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CodeScopesMappingIndex codeScopesMappingIndex;

    @Override
    protected KeyDelta getCommitTreeDelta() {
        return this.commitTreeDelta;
    }

    @Override
    protected void processCommitsForNodes(List<ICommitTreeNode> commitTreeNodes) throws StorageException {
        for (ICommitTreeNode node : commitTreeNodes) {
            this.processCommitForNode(node);
        }
    }

    private void processCommitForNode(ICommitTreeNode commitTreeNode) throws StorageException {
        PreCommitUploadCommit uploadInfo = (PreCommitUploadCommit)((Object)this.getExternalUploadIndex(commitTreeNode).getCommitInfo());
        if (uploadInfo == null) {
            LOGGER.error("Could not find any staged pre-commit data for {}", (Object)commitTreeNode);
            return;
        }
        ArrayList<BasicTokenElementInfo> contentValues = new ArrayList<BasicTokenElementInfo>();
        PairList historyValues = new PairList();
        ArrayList<RepositoryChangeEntry> changeEntries = new ArrayList<RepositoryChangeEntry>();
        ArrayList<RepositoryLogFileEntry> repositoryLogFileEntries = new ArrayList<RepositoryLogFileEntry>();
        Set<ELanguage> configuredLanguages = AnalysisProfileUtils.getConfiguredLanguages(this.projectMetaIndex);
        this.insertFiles(uploadInfo, (List<BasicTokenElementInfo>)contentValues, (PairList<String, ElementHistoryEntry>)historyValues, (List<RepositoryChangeEntry>)changeEntries, (List<RepositoryLogFileEntry>)repositoryLogFileEntries, ERepositoryChangeType.ADD, EElementHistoryChangeType.ADD, uploadInfo.getNewFiles(), (Set<String>)uploadInfo.getTestFiles(), configuredLanguages);
        this.insertFiles(uploadInfo, (List<BasicTokenElementInfo>)contentValues, (PairList<String, ElementHistoryEntry>)historyValues, (List<RepositoryChangeEntry>)changeEntries, (List<RepositoryLogFileEntry>)repositoryLogFileEntries, ERepositoryChangeType.EDIT, EElementHistoryChangeType.EDIT, uploadInfo.getChangedFiles(), (Set<String>)uploadInfo.getTestFiles(), configuredLanguages);
        this.basicElementIndex.setTokenElements(contentValues);
        this.codeScopesMappingIndex.setMappings(PreCommitUploadPersister.extractCodeScopeNames(contentValues));
        this.handleDeletions(uploadInfo, (PairList<String, ElementHistoryEntry>)historyValues, changeEntries, repositoryLogFileEntries);
        this.logFileIndex.insertEntries(repositoryLogFileEntries);
        this.projectRepositoryChangeIndex.addChangedFiles(changeEntries);
        this.projectRepositoryChangeIndex.mergeCommitTree(this.commitTreeIndex.loadTree(), this.projectMetaIndex.getDefaultBranchName(), "__precommit__");
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        this.writeRepositoryLogEntry(schedulingCommit, "Pre-Commit Upload: ", PreCommitUploadPersister.toRevisionString(schedulingCommit), uploadInfo.getUsername(), uploadInfo.getNewFiles().size(), uploadInfo.getChangedFiles().size(), uploadInfo.getDeletedFiles().size());
    }

    private static PairList<UniformPath, CodeScopeName> extractCodeScopeNames(List<BasicTokenElementInfo> basicTokenElementInfos) {
        PairList codeScopeNames = new PairList();
        for (BasicTokenElementInfo basicElement : basicTokenElementInfos) {
            Optional codeScopeDetail = basicElement.getFirstDetailOfType(CodeScopeDetail.class);
            CCSMAssert.isNotNull((Object)codeScopeDetail);
            CodeScopeName codeScopeName = ((CodeScopeDetail)((Object)codeScopeDetail.get())).getCodeScopeName();
            codeScopeNames.add((Object)UniformPathCompatibilityUtil.convert((String)basicElement.getUniformPath()), (Object)codeScopeName);
        }
        return codeScopeNames;
    }

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    @Override
    protected String getRepositoryIdentifier() {
        return "precommit";
    }

    @Override
    protected ECommitType getCommitType() {
        return ECommitType.CODE_COMMIT;
    }

    private void insertFiles(PreCommitUploadCommit uploadInfo, List<BasicTokenElementInfo> contentValues, PairList<String, ElementHistoryEntry> historyValues, List<RepositoryChangeEntry> changeEntries, List<RepositoryLogFileEntry> repositoryLogFileEntries, ERepositoryChangeType repositoryChangeType, EElementHistoryChangeType elementHistoryChangeType, PairList<String, String> pathAndContent, Set<String> testFiles, Set<ELanguage> configuredLanguages) {
        RepositoryContentUpdaterCodeScopeSupport codeScopeSupport = this.createCodeScopeSupport();
        pathAndContent.forEach((uniformPath, content) -> {
            ELanguage language = AmbiguousLanguageResolutionUtils.getLanguageFromUniformPath((Set)configuredLanguages, (String)UniformPathUtils.getElementName((String)uniformPath), (String)content);
            historyValues.add(uniformPath, (Object)new ElementHistoryEntry(elementHistoryChangeType, this.getSchedulingCommit(), EChangeEntryOrigin.PRE_COMMIT));
            List<TokenElementDetailBase> details = PreCommitUploadPersister.buildDetails(uniformPath, content, codeScopeSupport, testFiles);
            BasicTokenElementInfo element = new BasicTokenElementInfo(uniformPath, language, false, content, (Collection)CollectionUtils.emptyList(), details);
            contentValues.add(element);
            changeEntries.add(new RepositoryChangeEntry(UniformPathCompatibilityUtil.convert((String)uniformPath), PreCommitUploadPersister.toRevisionString(uploadInfo.getCommit()), repositoryChangeType, uploadInfo.getCommit(), EChangeEntryOrigin.PRE_COMMIT));
            repositoryLogFileEntries.add(new RepositoryLogFileEntry(this.getSchedulingCommit(), UniformPathCompatibilityUtil.convert((String)uniformPath), ECommitType.CODE_COMMIT, null, false));
        });
    }

    private @Nullable RepositoryContentUpdaterCodeScopeSupport createCodeScopeSupport() {
        ProjectConfiguration configuration;
        try {
            configuration = (ProjectConfiguration)this.projectMetaIndex.getValue(ProjectConfiguration.class);
        }
        catch (StorageException e) {
            LOGGER.error("Could not load code scopes from project configuration. Assuming all files are in the default code scope.", (Throwable)e);
            return null;
        }
        return RepositoryContentUpdaterCodeScopeSupport.buildFromCodeScopes(configuration.getCodeScopes());
    }

    private static List<TokenElementDetailBase> buildDetails(String uniformPath, String content, RepositoryContentUpdaterCodeScopeSupport support, Set<String> testFiles) {
        ArrayList<TokenElementDetailBase> details = new ArrayList<TokenElementDetailBase>();
        details.add(PreCommitUploadPersister.buildCodeScopeDetail(uniformPath, content, support));
        if (testFiles.contains(uniformPath)) {
            details.add(new PartOfTestCodeDetail());
        }
        return details;
    }

    private static CodeScopeDetail buildCodeScopeDetail(String uniformPath, String content, RepositoryContentUpdaterCodeScopeSupport support) {
        CodeScopeName codeScopeName = CodeScopeAware.DEFAULT_CODE_SCOPE;
        if (support != null) {
            try {
                codeScopeName = support.determineCodeScope(uniformPath, content);
            }
            catch (ConQATException e) {
                LOGGER.error("Could not determine code scope for file {} assuming the default code scope.", (Object)uniformPath, (Object)e);
            }
        }
        return new CodeScopeDetail(codeScopeName);
    }

    private void handleDeletions(PreCommitUploadCommit uploadInfo, PairList<String, ElementHistoryEntry> historyValues, List<RepositoryChangeEntry> changeEntries, List<RepositoryLogFileEntry> repositoryLogFileEntries) throws StorageException {
        for (String deletedPath : uploadInfo.getDeletedFiles()) {
            historyValues.add((Object)deletedPath, (Object)new ElementHistoryEntry(EElementHistoryChangeType.DELETE, this.getSchedulingCommit(), EChangeEntryOrigin.PRE_COMMIT));
            changeEntries.add(new RepositoryChangeEntry(UniformPathCompatibilityUtil.convert((String)deletedPath), PreCommitUploadPersister.toRevisionString(uploadInfo.getCommit()), ERepositoryChangeType.DELETE, uploadInfo.getCommit(), EChangeEntryOrigin.PRE_COMMIT));
            repositoryLogFileEntries.add(new RepositoryLogFileEntry(this.getSchedulingCommit(), UniformPathCompatibilityUtil.convert((String)deletedPath), ECommitType.CODE_COMMIT, null, true));
        }
        this.basicElementIndex.removeTokenElements(uploadInfo.getDeletedFiles());
        this.codeScopesMappingIndex.removeMappings(UniformPathCompatibilityUtil.convertCollection(uploadInfo.getDeletedFiles()));
    }

    @Override
    protected IBranchingLayer getExternalUploadBranchingLayer() {
        return this.preCommitUploadStagingBranchingLayer;
    }

    protected PreCommitUploadStagingIndex createExternalUploadIndex(IStore store) {
        return new PreCommitUploadStagingIndex(store);
    }

    private static String toRevisionString(CommitDescriptor commit) {
        return "Pre-Commit Upload: " + DateTimeUtils.getUiFormattedDateString((long)commit.getTimestamp());
    }
}

