/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoCompilationCommand;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.report.AnalysisReportIntegrator;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.ReportParserFactory;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.CompileCommandReportContentIndex;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class CompileCommandIntegrator
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CompileCommandReportContentIndex reportContentIndex;
    @DeltaSource(value=CompileCommandReportContentIndex.class)
    private KeyDelta reportContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CompileCommandIndex compileCommandIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisStatusIndex statusIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathLookupIndex pathLookupIndex;
    private IMatchingPathsLookup matchingPathsLookup = null;
    private final Set<String> allReportPartitions = new HashSet<String>();
    private final EnumSet<EReportFormat> allReportFormats = EnumSet.noneOf(EReportFormat.class);

    public void execute() throws StorageException {
        List changedPaths = this.reportContentDelta.getAddedOrChangedKeysAsStrings();
        List<ReportContentIndexBase.ReportContent> contents = this.reportContentIndex.getReportContents(changedPaths);
        try {
            PairList pathAndCommand = new PairList();
            for (int i = 0; i < changedPaths.size(); ++i) {
                this.allReportPartitions.add(contents.get(i).getPartitionOrElse("external-data-imported-from-repository"));
                this.allReportFormats.add(contents.get((int)i).format);
                this.parseReport((String)changedPaths.get(i), contents.get(i), (PairList<String, CompilationCommand>)pathAndCommand);
            }
            if (!pathAndCommand.isEmpty()) {
                this.compileCommandIndex.putCommands((PairList<String, CompilationCommand>)pathAndCommand);
            }
            AnalysisReportIntegrator.reportStatus(null, this.allReportPartitions, this.allReportFormats, this.getSchedulingCommit(), this.statusIndex);
        }
        catch (Throwable t) {
            AnalysisReportIntegrator.reportStatus(t, this.allReportPartitions, this.allReportFormats, this.getSchedulingCommit(), this.statusIndex);
            throw t;
        }
    }

    private void parseReport(String reportPath, ReportContentIndexBase.ReportContent reportContent, PairList<String, CompilationCommand> pathAndCommand) throws StorageException {
        IReportParser parser = ReportParserFactory.createParser(reportContent.format);
        parser.init(this.basicTokenElementIndex, null, null, null, this.getMatchingPathsLookup(), null, null, null, this.projectMetaIndex, false, (x$0, x$1, x$2) -> this.executeInParallelBatches(x$0, x$1, x$2), null);
        try {
            parser.parse(reportContent, reportPath);
            parser.getInfos().filterByType(ExternalAnalysisImportInfoCompilationCommand.class).forEach(compilationCommand -> pathAndCommand.add((Object)compilationCommand.getUniformPath(), (Object)compilationCommand.getData()));
        }
        catch (ReportParserException e) {
            LOGGER.error("Failed parsing {}: {}", (Object)reportPath, (Object)e.getMessage(), (Object)e);
        }
    }

    private IMatchingPathsLookup getMatchingPathsLookup() throws StorageException {
        if (this.matchingPathsLookup == null) {
            this.matchingPathsLookup = this.pathLookupIndex.createLoggingPreloadedLookup();
        }
        return this.matchingPathsLookup;
    }
}

