/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.teamscale.commons.service.XmlSerializationUtils;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class PCLintReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FLEXELINT_RESULTS_TAG = "<results>";
    private static final Set<String> ENTIRE_FILE_CHECK_IDS = Set.of("766");
    private PcLintDocTag report;

    @Override
    public void parseStringReportInternal(String reportString, @Nullable String reportPath) throws ReportParserException {
        try {
            this.report = reportString.contains(FLEXELINT_RESULTS_TAG) ? new PcLintDocTag((FlexeLintResultTag)XmlSerializationUtils.deserializeFromXML((String)reportString, FlexeLintResultTag.class)) : (PcLintDocTag)XmlSerializationUtils.deserializeFromXML((String)reportString, PcLintDocTag.class);
        }
        catch (IOException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (Message message : CollectionUtils.emptyIfNull(this.report.message)) {
            DetachedFinding finding;
            if (!PCLintReportParser.isValidMessage(message)) {
                LOGGER.warn("Ignored invalid message: " + String.valueOf(message));
                continue;
            }
            Optional<String> uniformPath = this.resolvePath(message.file);
            if (uniformPath.isEmpty()) continue;
            if (ENTIRE_FILE_CHECK_IDS.contains(message.code)) {
                finding = PCLintReportParser.createFileFinding(uniformPath.get(), message.code, "pclint", message.desc);
            } else {
                int line;
                try {
                    line = Integer.parseInt(message.line);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Ignored message with invalid line information: " + String.valueOf(message));
                    continue;
                }
                finding = PCLintReportParser.createLineFinding(line, uniformPath.get(), message.code, "pclint", message.desc);
            }
            this.addFindingForPath(uniformPath.get(), finding);
        }
    }

    private static boolean isValidMessage(Message message) {
        return !StringUtils.isEmpty((String)message.file) && !StringUtils.isEmpty((String)message.line) && !StringUtils.isEmpty((String)message.code) && !StringUtils.isEmpty((String)message.desc);
    }

    @XmlRootElement(name="doc")
    private static class PcLintDocTag {
        @JacksonXmlElementWrapper(useWrapping=false)
        public List<Message> message;

        @JsonCreator
        public PcLintDocTag() {
        }

        private PcLintDocTag(FlexeLintResultTag flexeLintTag) {
            this.message = CollectionUtils.map(flexeLintTag.issue, Message::new);
        }
    }

    @XmlRootElement(name="results")
    private static class FlexeLintResultTag {
        @JacksonXmlElementWrapper(useWrapping=false)
        public List<Issue> issue;

        private FlexeLintResultTag() {
        }
    }

    @XmlRootElement(name="message")
    private static class Message {
        public String file;
        public String line;
        public String type;
        public String code;
        public String desc;

        @JsonCreator
        public Message() {
        }

        public Message(Issue issue) {
            this.file = issue.file;
            this.line = issue.line;
            this.type = issue.type;
            this.code = issue.number;
            this.desc = issue.desc;
        }

        public String toString() {
            return "Message [file=" + this.file + ", line=" + this.line + ", type=" + this.type + ", code=" + this.code + ", desc=" + this.desc + "]";
        }
    }

    @XmlRootElement(name="issue")
    private static class Issue {
        @XmlAttribute
        public String file;
        @XmlAttribute
        public String line;
        @XmlAttribute
        public String type;
        @XmlAttribute
        public String desc;
        @XmlAttribute
        public String number;

        private Issue() {
        }

        public String toString() {
            return "Issue [file=" + this.file + ", line=" + this.line + ", type=" + this.type + ", desc=" + this.desc + ", number=" + this.number + "]";
        }
    }
}

