/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.external.result.ExternalAnalysisResultProbeCoverage;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.testcoverage.ProbeCoverageIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultProbeCoverageProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultProbeCoverage> {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProbeCoverageIndex probeCoverageIndex;
    private final Map<String, Map<String, ProbeCoverageInfo>> probeCoverageInfosPerPartition = new HashMap<String, Map<String, ProbeCoverageInfo>>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultProbeCoverage> getResultClass() {
        return ExternalAnalysisResultProbeCoverage.class;
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultProbeCoverage analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        Map coverageInfo = this.probeCoverageInfosPerPartition.computeIfAbsent(partition, x -> new HashMap());
        ProbeCoverageInfo oldValue = coverageInfo.put(uniformPath.toString(), analysisResult.getData());
        if (oldValue != null) {
            LOGGER.error("Encountered multiple probe coverage entries for path " + String.valueOf(uniformPath) + " and partition " + partition + " which is not supported! Only one of the values will be considered.");
        }
        return true;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        if (this.probeCoverageInfosPerPartition.isEmpty()) {
            return;
        }
        this.probeCoverageIndex.setCoverageInfos(this.probeCoverageInfosPerPartition);
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        this.probeCoverageIndex.removeCoverage(deletedPartitionAndPaths);
    }

    @Override
    public void reset() {
        this.probeCoverageInfosPerPartition.clear();
    }
}

