/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.git.gerrit.GerritPatchSetInfo;
import java.util.Objects;

class GerritCommitInfo
extends GerritPatchSetInfo {
    private final String commitHash;

    public GerritCommitInfo(long changeNumber, long patchSetNumber, String commitHash) {
        super(changeNumber, patchSetNumber);
        Preconditions.checkNotNull((Object)commitHash, (Object)"Commit hash can't be empty.");
        this.commitHash = commitHash;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    @Override
    public String toString() {
        return "GerritCommitInfo{changeNumber=" + this.getChangeNumber() + ", patchSetNumber=" + this.getPatchSetNumber() + ", commitHash='" + this.commitHash + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GerritCommitInfo that = (GerritCommitInfo)o;
        return this.commitHash.equals(that.commitHash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commitHash);
    }
}

