/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.google.common.collect.ImmutableSet;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestTestGapInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.git.gerrit.GerritAnalysisResultUploader;
import com.teamscale.index.repository.git.gerrit.data.ReviewInput;
import com.teamscale.index.testgap.ETestGapState;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.Nullable;

public class GerritVotingInput {
    public final MergeRequest mergeRequest;
    public final RepositoryLogEntry logEntryToVoteOn;
    public final String changeNumber;
    protected int findingsCommentsLimit;

    protected GerritVotingInput(MergeRequest mergeRequest, RepositoryLogEntry logEntryToVoteOn) {
        this.mergeRequest = mergeRequest;
        this.changeNumber = Long.toString(mergeRequest.identifier.id());
        this.logEntryToVoteOn = logEntryToVoteOn;
    }

    public static class WithDelta
    extends GerritVotingInput {
        public final Set<String> changedFiles;
        public final GerritAnalysisResultUploader.FilteredFindings filteredFindings;
        public final MergeBaseInfo mergeBase;
        public final CommitDescriptor lastCommit;
        public final RepositoryLogEntryAggregate logEntryForLastCommit;
        public final @Nullable Integer numberOfAffectedSpecItems;
        public final @Nullable MergeRequestTestGapInfo testGapInfo;
        public final @Nullable CommitAlerts commitAlerts;

        public WithDelta(MergeRequest mergeRequest, Set<String> changedFiles, GerritAnalysisResultUploader.FilteredFindings filteredFindings, RepositoryLogEntry logEntryToVoteOn, MergeBaseInfo mergeBase, CommitDescriptor lastCommit, RepositoryLogEntryAggregate logEntryForLastCommit, @Nullable Integer numberOfAffectedSpecItems, @Nullable MergeRequestTestGapInfo testGapInfo, @Nullable CommitAlerts commitAlerts) {
            super(mergeRequest, logEntryToVoteOn);
            this.changedFiles = ImmutableSet.copyOf(changedFiles);
            this.filteredFindings = filteredFindings;
            this.mergeBase = mergeBase;
            this.lastCommit = lastCommit;
            this.logEntryForLastCommit = logEntryForLastCommit;
            this.numberOfAffectedSpecItems = numberOfAffectedSpecItems;
            this.testGapInfo = testGapInfo;
            this.commitAlerts = commitAlerts;
        }

        public @Nullable CounterSet<ETestGapState> getTestGapStates() {
            if (this.testGapInfo != null) {
                return this.testGapInfo.testGapStates();
            }
            return null;
        }
    }

    public static class WithReviewInput
    extends GerritVotingInput {
        public final ReviewInput reviewInput;

        public WithReviewInput(MergeRequest mergeRequest, RepositoryLogEntry logEntryToVoteOn, ReviewInput reviewInput) {
            super(mergeRequest, logEntryToVoteOn);
            this.reviewInput = reviewInput;
        }
    }
}

