/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestBuildStatus;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.GitHubCrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.github.GitHubMergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.GitHubBuildJob;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.GitHubDataFetchConfiguration;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.GitHubMergeRequestDataFetchStrategyFactory;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.IGitHubMergeRequestDataFetchStrategy;
import java.time.Instant;
import java.util.List;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;

public class GitHubMergeRequestProvider
extends MergeRequestProvider<GitHubPullRequest, GitHubBuildJob> {
    private static final String OPEN_STATE = "open";
    private static final String CLOSED_STATE = "closed";
    private final PlatformRepositoryIdentifier repositoryIdentifier;
    private final GitHubPullRequestClient client;
    private final IGitHubMergeRequestDataFetchStrategy dataFetchStrategy;

    public GitHubMergeRequestProvider(GitHubDataFetchConfiguration dataFetchConfiguration, String repositoryName, IncludeExcludeRegexSupport buildIncludeExcludePatterns, String contextIdentifier) {
        super(new GitHubCrossRepositoryMergeRequestHandler(), new GitHubMergeRequestBuildJobHandler(dataFetchConfiguration, buildIncludeExcludePatterns, PlatformRepositoryIdentifier.fromRepositoryName(repositoryName), contextIdentifier));
        this.client = dataFetchConfiguration.client();
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        this.dataFetchStrategy = GitHubMergeRequestDataFetchStrategyFactory.create(dataFetchConfiguration);
    }

    @Override
    protected List<GitHubPullRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        return this.dataFetchStrategy.getAllOpenPlatformMergeRequests(this.repositoryIdentifier);
    }

    @Override
    public GitHubPullRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        try {
            return this.dataFetchStrategy.getPlatformMergeRequest(this.repositoryIdentifier, (int)id);
        }
        catch (StorageException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(GitHubPullRequest pullRequest) {
        return new GitHubMergeRequestAdapter(pullRequest);
    }

    @Override
    protected MergeRequestProvider.IMergeRequestBuildJobAdapter createMergeRequestBuildJobAdapter(GitHubBuildJob gitHubBuildJob) {
        return new GitHubMergeRequestBuildJobAdapter(gitHubBuildJob);
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest(@NonNull GitHubPullRequest pullRequest) {
        return GitHubCrossRepositoryMergeRequestHandler.isCrossRepoMergeRequest(pullRequest);
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryIdentifier.asRepositoryName();
    }

    private class GitHubMergeRequestAdapter
    implements MergeRequestProvider.IMergeRequestAdapter {
        private final GitHubPullRequest pullRequest;

        private GitHubMergeRequestAdapter(GitHubPullRequest pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public MergeRequestIdentifier getIdentifier() {
            return new MergeRequestIdentifier(GitHubMergeRequestProvider.this.repositoryIdentifier.asRepositoryName(), (long)this.pullRequest.number());
        }

        @Override
        public EMergeRequestStatus getStatus() {
            String pullRequestState = this.pullRequest.state();
            if (GitHubMergeRequestProvider.OPEN_STATE.equals(pullRequestState)) {
                return EMergeRequestStatus.OPEN;
            }
            if (GitHubMergeRequestProvider.CLOSED_STATE.equals(pullRequestState) && this.pullRequest.merged()) {
                return EMergeRequestStatus.MERGED;
            }
            return EMergeRequestStatus.OTHER;
        }

        @Override
        public String getTitle() {
            return this.pullRequest.title();
        }

        @Override
        public String getSourceBranch() {
            return this.pullRequest.head().branchName();
        }

        @Override
        public String getCommit() {
            return this.pullRequest.head().sha();
        }

        @Override
        public String getTargetBranch() {
            return this.pullRequest.base().branchName();
        }

        @Override
        public String getUrl() {
            return this.pullRequest.htmlUrl();
        }

        @Override
        public Long getCreatedAt() {
            return Instant.parse(this.pullRequest.createdAt()).toEpochMilli();
        }

        @Override
        public Long getUpdatedAt() {
            return Instant.parse(this.pullRequest.updatedAt()).toEpochMilli();
        }
    }

    private record GitHubMergeRequestBuildJobAdapter(GitHubBuildJob gitHubBuildJob) implements MergeRequestProvider.IMergeRequestBuildJobAdapter
    {
        @Override
        public EMergeRequestBuildStatus getStatus() {
            return switch (this.gitHubBuildJob.status()) {
                case "completed", "success", "failure", "error" -> EMergeRequestBuildStatus.COMPLETED;
                case "in_progress", "queued", "pending" -> EMergeRequestBuildStatus.IN_PROGRESS;
                default -> EMergeRequestBuildStatus.UNKNOWN;
            };
        }

        @Override
        public @NonNull String getName() {
            return this.gitHubBuildJob.name();
        }
    }
}

