/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRuns;
import com.teamscale.index.repository.git.github.data.CombinedCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubChangedFile;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.data.GitHubPullRequestComment;
import com.teamscale.index.repository.git.github.data.MetaInfo;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface IGitHubPullRequestApi
extends IRetrofitApi {
    public static final String PULL_REQUEST_NUMBER_PARAM_NAME = "pullRequestNumber";
    public static final String COMMENT_ID_PARAM_NAME = "commentId";
    public static final String CHECK_RUN_ID_PARAM_NAME = "checkRunId";
    public static final String REF_PARAM_NAME = "ref";
    public static final String STATUS_PARAM_NAME = "status";
    public static final String PULL_REQUEST_COMMENTS_ENDPOINT = "repos/{owner}/{repo}/issues/{pullRequestNumber}/comments";
    public static final String PULL_REQUEST_SINGLE_COMMENT_ENDPOINT = "repos/{owner}/{repo}/issues/comments/{commentId}";
    public static final String PULL_REQUESTS_ENDPOINT = "repos/{owner}/{repo}/pulls";
    public static final String SINGLE_PULL_REQUEST_ENDPOINT = "repos/{owner}/{repo}/pulls/{pullRequestNumber}";
    public static final String PULL_REQUEST_FILES_ENDPOINT = "repos/{owner}/{repo}/pulls/{pullRequestNumber}/files";
    public static final String CHECK_RUNS_ENDPOINT = "repos/{owner}/{repo}/check-runs";
    public static final String SINGLE_CHECK_RUN_ENDPOINT = "repos/{owner}/{repo}/check-runs/{checkRunId}";
    public static final String COMMIT_PATH = "repos/{owner}/{repo}/commits/{ref}";
    public static final String COMMIT_CHECK_RUNS_ENDPOINT = "repos/{owner}/{repo}/commits/{ref}/check-runs";
    public static final String COMBINED_COMMIT_STATUS_ENDPOINT = "repos/{owner}/{repo}/commits/{ref}/status";
    public static final String COLLABORATORS_USER_ENDPOINT = "repos/{owner}/{repo}/collaborators/{username}";

    @GET(value="repos/{owner}/{repo}/issues/{pullRequestNumber}/comments")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubPullRequestComment[]> getPullRequestComments(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="pullRequestNumber") int var3, @Query(value="per_page") int var4);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubPullRequestComment[]> getPullRequestCommentsFromNextPage(@Url String var1);

    @DELETE(value="repos/{owner}/{repo}/issues/comments/{commentId}")
    public Void deletePullRequestComment(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="commentId") long var3) throws ServiceCallException;

    @POST(value="repos/{owner}/{repo}/issues/{pullRequestNumber}/comments")
    public Void createPullRequestComment(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="pullRequestNumber") int var3, @Body GitHubPullRequestComment var4) throws ServiceCallException;

    @GET(value="repos/{owner}/{repo}/pulls?state=open")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubPullRequest[]> getOpenPullRequests(@Path(value="owner") String var1, @Path(value="repo") String var2, @Query(value="per_page") int var3);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubPullRequest[]> getOpenPullRequestsFromNextPage(@Url String var1);

    @GET(value="repos/{owner}/{repo}/pulls/{pullRequestNumber}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public GitHubPullRequest getPullRequest(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="pullRequestNumber") int var3) throws ServiceCallException;

    @GET(value="repos/{owner}/{repo}/pulls/{pullRequestNumber}/files")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubChangedFile[]> getPullRequestFiles(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="pullRequestNumber") int var3, @Query(value="per_page") int var4);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<GitHubChangedFile[]> getPullRequestFilesFromNextPage(@Url String var1);

    @POST(value="repos/{owner}/{repo}/check-runs")
    @Headers(value={"Accept: application/vnd.github+json"})
    public CheckRun createCheckRun(@Path(value="owner") String var1, @Path(value="repo") String var2, @Body CheckRun var3) throws ServiceCallException;

    @GET(value="repos/{owner}/{repo}/check-runs/{checkRunId}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public CheckRun getCheckRunById(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="checkRunId") long var3) throws ServiceCallException;

    @PATCH(value="repos/{owner}/{repo}/check-runs/{checkRunId}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Void updateCheckRun(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="checkRunId") long var3, @Body CheckRun var5) throws ServiceCallException;

    @GET(value="repos/{owner}/{repo}/commits/{ref}/check-runs")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<CheckRuns> getCheckRunsForCommit(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="ref") String var3, @Query(value="per_page") int var4);

    @GET(value="repos/{owner}/{repo}/commits/{ref}/check-runs?filter=all")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<CheckRuns> getCheckRunsForCommit(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="ref") String var3, @Query(value="status") String var4, @Query(value="per_page") int var5);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<CheckRuns> getCheckRunsForCommitFromNextPage(@Url String var1);

    @GET(value="repos/{owner}/{repo}/commits/{ref}/status")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<CombinedCommitStatus> getCombinedCommitStatus(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="ref") String var3, @Query(value="per_page") int var4);

    @GET
    @Headers(value={"Accept: application/vnd.github+json"})
    public Call<CombinedCommitStatus> getCombinedCommitStatusFromNextPage(@Url String var1);

    @GET(value="repos/{owner}/{repo}/collaborators/{username}")
    @Headers(value={"Accept: application/vnd.github+json"})
    public Void checkUserIsCollaborator(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="username") String var3) throws ServiceCallException;

    @GET(value="meta")
    public MetaInfo getMetaInfoForEnterpriseInstance() throws ServiceCallException;
}

