/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.data.CheckRunBuilder;
import com.teamscale.index.repository.git.github.data.CheckRunPullRequest;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public record CheckRun(@SerializedName(value="id") @JsonProperty(value="id") Long id, @SerializedName(value="name") @JsonProperty(value="name") String name, @SerializedName(value="head_sha") @JsonProperty(value="head_sha") String headSha, @SerializedName(value="details_url") @JsonProperty(value="details_url") String detailsUrl, @SerializedName(value="status") @JsonProperty(value="status") Status status, @SerializedName(value="conclusion") @JsonProperty(value="conclusion") @Nullable Conclusion conclusion, @SerializedName(value="started_at") @JsonProperty(value="started_at") @Nullable String startedAt, @SerializedName(value="completed_at") @JsonProperty(value="completed_at") @Nullable String completedAt, @SerializedName(value="output") @JsonProperty(value="output") Output output, @SerializedName(value="pull_requests") @JsonProperty(value="pull_requests") @Nullable CheckRunPullRequest[] pullRequests) implements Serializable
{
    static final DateTimeFormatter ISO_8601_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final String QUEUED_STATUS = "queued";
    public static final String IN_PROGRESS_STATUS = "in_progress";
    public static final String COMPLETED_STATUS = "completed";

    public @Nullable LocalDateTime parseStartDate() throws DateTimeParseException {
        return CheckRun.parseDateTime(this.startedAt());
    }

    private static @Nullable LocalDateTime parseDateTime(@Nullable String iso8601String) {
        if (iso8601String == null) {
            return null;
        }
        return LocalDateTime.parse(iso8601String, ISO_8601_FORMAT);
    }

    public static CheckRunBuilder builder(ECheckRunType type, String contextIdentifier, String headSha, String detailsUrl) {
        return new CheckRunBuilder(headSha, type).withContextIdentifier(contextIdentifier).withDetailsUrl(URI.create(detailsUrl));
    }

    public static CheckRunBuilder builder(CheckRun checkRun) {
        return new CheckRunBuilder(checkRun);
    }

    @IndexValueClass
    public static enum Status {
        QUEUED,
        IN_PROGRESS,
        COMPLETED,
        WAITING,
        REQUESTED,
        PENDING;

    }

    @IndexValueClass
    public static enum Conclusion {
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SUCCESS,
        SKIPPED,
        STALE,
        TIMED_OUT;

    }

    @IndexValueClass
    public record Output(@SerializedName(value="title") @JsonProperty(value="title") String title, @SerializedName(value="summary") String summary, @SerializedName(value="text") @JsonProperty(value="text") String text, @SerializedName(value="annotations") @JsonProperty(value="annotations") @Nullable CheckRunAnnotation[] annotations) implements Serializable
    {
    }

    @IndexValueClass
    public record CheckRunAnnotation(@SerializedName(value="path") @JsonProperty(value="path") String path, @SerializedName(value="start_line") @JsonProperty(value="start_line") int startLine, @SerializedName(value="end_line") @JsonProperty(value="end_line") int endLine, @SerializedName(value="annotation_level") @JsonProperty(value="annotation_level") Level annotationLevel, @SerializedName(value="message") @JsonProperty(value="message") String message) implements Serializable
    {

        @IndexValueClass
        public static enum Level {
            NOTICE,
            WARNING,
            FAILURE;

        }
    }
}

