/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.index.repository.sap.abapsystem.AsynchronousAbapUpdateTrigger;
import com.teamscale.index.repository.sap.abapsystem.snc.SncUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="sap.abap.global", name="SAP ABAP System Connections - Global Settings", type=EOptionType.SERVER, category=EOptionCategory.SAP, orderingHint=90)
@IndexValueClass(containedInBackup=true)
public class GlobalSapSystemConnectionOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "sap.abap.global";
    public static final String OPTION_NAME = "SAP ABAP System Connections - Global Settings";
    @JsonProperty(value="jcoSncLibrary")
    @OptionFieldDescription(name="Full path to the OS library which provides the SNC service (optional)", description="If environment variable, SNC_LIB, is set, you may skip this option.")
    public String jcoSncLibrary = "";
    @JsonProperty(value="asynchronousExportResultRequestSchedule")
    @OptionFieldDescription(name="Schedule for requesting results of asynchronous ABAP exports (for example '*/10 * * * *' to check every 10 minutes if background job in SAP system has finished)")
    @ScheduleOption(triggerClass=AsynchronousAbapUpdateTrigger.class)
    public String asynchronousExportResultRequestSchedule = "*/10 * * * *";
    @JsonProperty(value="maxAsynchronousWaitHours")
    @OptionFieldDescription(name="Maximum wait time in hours for results of asynchronous ABAP export jobs. Scheduled jobs will not be polled anymore for results after this time-out.")
    public int maxAsynchronousWaitHours = 24;
    private static final int DEFAULT_ABAP_SYSTEM_LOGON_TIMEOUT = 5;
    @JsonProperty(value="abapSystemLogonTimeout")
    @OptionFieldDescription(name="Timeout in seconds for logon connections to an ABAP system. Value range is 1 - 3600. This does not apply to connections during validation after SAP settings are saved.")
    public int abapSystemLogonTimeout = 5;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (StringUtils.isEmpty((String)this.jcoSncLibrary)) {
            return null;
        }
        return SncUtils.validateServiceLibrary(this.jcoSncLibrary).orElse(null);
    }
}

