/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sca.jfrog;

import com.teamscale.index.repository.sca.BuildInfo;
import com.teamscale.index.repository.sca.BuildScanResult;
import com.teamscale.index.repository.sca.BuildVersion;
import com.teamscale.index.repository.sca.IgnoreViolationRule;
import com.teamscale.index.repository.sca.NameWithVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="jfrog-xray-index", valueClasses={BuildInfo.class, BuildScanResult.class, NameWithVersion.class, BuildVersion.class, IgnoreViolationRule.class}, options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.BACKUP})
public class JFrogXrayIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "jfrog-xray-index";

    public JFrogXrayIndex(IStore store) {
        super(store);
    }

    public void storeBuilds(List<BuildInfo> builds) throws StorageException {
        if (builds.isEmpty()) {
            return;
        }
        PairList mapping = new PairList();
        for (BuildInfo build : builds) {
            mapping.add((Object)(String.valueOf((Object)EStorePrefix.BUILDS) + build.name() + "#-#"), (Object)StorageUtils.serialize((Serializable)build));
        }
        this.store.putWithStrings(mapping);
    }

    public List<BuildInfo> getBuilds() throws StorageException {
        PairList entries = StorageUtils.listStringKeysAndValues((IStore)this.store);
        return JFrogXrayIndex.toBuilds(entries.filter((key, value) -> key.startsWith(EStorePrefix.BUILDS.prefix)).extractSecondList());
    }

    private static List<BuildInfo> toBuilds(List<byte[]> entries) throws StorageException {
        ArrayList<BuildInfo> result = new ArrayList<BuildInfo>();
        for (byte[] entry : entries) {
            if (entry == null) {
                result.add(null);
                continue;
            }
            result.add((BuildInfo)StorageUtils.deserialize((byte[])entry));
        }
        return result;
    }

    public void storeScanResultsForBuilds(List<BuildScanResult> scanResults) throws StorageException {
        if (scanResults.isEmpty()) {
            return;
        }
        PairList entries = new PairList();
        for (BuildScanResult scanResult : scanResults) {
            entries.add((Object)JFrogXrayIndex.getScanResultKey(scanResult.build().name(), scanResult.build().version()), (Object)StorageUtils.serialize((Serializable)scanResult));
        }
        this.store.putWithStrings(entries);
    }

    public void storeCommitHashesForBuild(PairList<NameWithVersion, ArrayList<String>> buildsWithRevisions) throws StorageException {
        PairList entries = new PairList();
        SetMap buildsByCommitHashes = new SetMap();
        for (Pair buildWithCommitHashes : buildsWithRevisions) {
            entries.add((Object)(String.valueOf((Object)EStorePrefix.BUILD_CODE_REVISIONS) + ((NameWithVersion)buildWithCommitHashes.getFirst()).name() + "#-#" + ((NameWithVersion)buildWithCommitHashes.getFirst()).version()), (Object)StorageUtils.serialize((Serializable)((Serializable)buildWithCommitHashes.getSecond())));
            for (String commitHash : (ArrayList)buildWithCommitHashes.getSecond()) {
                buildsByCommitHashes.add((Object)commitHash, (Object)((NameWithVersion)buildWithCommitHashes.getFirst()));
            }
        }
        for (Map.Entry commitHashWithBuild : buildsByCommitHashes) {
            entries.add((Object)((String)commitHashWithBuild.getKey()), (Object)StorageUtils.serialize((Serializable)((Serializable)((Set)commitHashWithBuild.getValue()).stream().collect(CollectionUtils.toArrayList()))));
        }
        this.store.putWithStrings(entries);
    }

    public List<String> getRevisionsForBuild(NameWithVersion build) throws StorageException {
        byte[] value = this.store.getWithString(String.valueOf((Object)EStorePrefix.BUILD_CODE_REVISIONS) + build.name() + "#-#" + build.version());
        if (value == null) {
            return Collections.emptyList();
        }
        return (List)((Object)StorageUtils.deserialize((byte[])value));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<BuildScanResult> getScanResultsForBuilds(List<NameWithVersion> buildVersions) throws StorageException {
        @Nullable List rawValues = this.store.getWithStrings(buildVersions.stream().map(version -> JFrogXrayIndex.getScanResultKey(version.name(), version.version())).toList());
        ArrayList<BuildScanResult> result = new ArrayList<BuildScanResult>();
        for (byte[] rawValue : rawValues) {
            if (rawValue == null) continue;
            result.add((BuildScanResult)StorageUtils.deserialize((byte[])rawValue));
        }
        return result;
    }

    private static String getScanResultKey(String buildName, String buildNumber) {
        return String.valueOf((Object)EStorePrefix.SCAN_RESULTS) + buildName + "#-#" + buildNumber;
    }

    public ArrayList<BuildVersion> getBuildVersions(String buildName) throws StorageException {
        byte[] entries = this.store.getWithString(String.valueOf((Object)EStorePrefix.BUILD_VERSIONS) + buildName + "#-#");
        if (entries == null) {
            return new ArrayList<BuildVersion>();
        }
        return (ArrayList)StorageUtils.deserialize((byte[])entries);
    }

    public Map<NameWithVersion, BuildInfo> getBuilds(Collection<NameWithVersion> buildsWithVersion) throws StorageException {
        List entries = this.store.getWithStrings(buildsWithVersion.stream().map(buildNameWithVersion -> String.valueOf((Object)EStorePrefix.BUILDS) + buildNameWithVersion.name() + "#-#" + buildNameWithVersion.version() + "#-#").toList());
        return PairList.zip(buildsWithVersion.stream().toList(), JFrogXrayIndex.toBuilds(entries)).toMap();
    }

    public void storeBuildVersions(PairList<String, ArrayList<BuildVersion>> buildNameWithVersions) throws StorageException {
        PairList values = new PairList();
        for (Pair buildVersion : buildNameWithVersions) {
            values.add((Object)(String.valueOf((Object)EStorePrefix.BUILD_VERSIONS) + (String)buildVersion.getFirst() + "#-#"), (Object)StorageUtils.serialize((Serializable)((Serializable)buildVersion.getSecond())));
        }
        this.store.putWithStrings(values);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public SetMap<String, NameWithVersion> getBuildsForRevisions(List<String> revisions) throws StorageException {
        SetMap result = new SetMap();
        @Nullable List entries = this.store.getWithStrings(revisions);
        for (int i = 0; i < entries.size(); ++i) {
            byte[] entry = (byte[])entries.get(i);
            if (entry == null) continue;
            result.addAll((Object)revisions.get(i), (Collection)((Object)StorageUtils.deserialize((byte[])entry)));
        }
        return result;
    }

    public void storeIgnoreRules(List<IgnoreViolationRule> ignoreRules) throws StorageException {
        PairList values = new PairList();
        for (IgnoreViolationRule ignoreRule : ignoreRules) {
            values.add((Object)(String.valueOf((Object)EStorePrefix.IGNORE_RULES) + ignoreRule.id()), (Object)StorageUtils.serialize((Serializable)ignoreRule));
        }
        this.store.putWithStrings(values);
    }

    public List<IgnoreViolationRule> getIgnoreRules() throws StorageException {
        PairList values = this.store.getEntriesStartingWith(EStorePrefix.IGNORE_RULES.prefix);
        ArrayList<IgnoreViolationRule> rules = new ArrayList<IgnoreViolationRule>();
        for (Pair value : values) {
            rules.add((IgnoreViolationRule)StorageUtils.deserialize((byte[])((byte[])value.getSecond())));
        }
        return rules;
    }

    public @Nullable IgnoreViolationRule getIgnoreRule(String ruleId) throws StorageException {
        byte[] rule = this.store.getWithString(EStorePrefix.IGNORE_RULES.prefix + ruleId);
        if (rule == null) {
            return null;
        }
        return (IgnoreViolationRule)StorageUtils.deserialize((byte[])rule);
    }

    public void storeLatestBuildVersions(Map<String, String> newestVersionByBuildName) throws StorageException {
        PairList values = new PairList();
        newestVersionByBuildName.forEach((buildName, latestVersion) -> values.add((Object)(String.valueOf((Object)EStorePrefix.LATEST_BUILD_VERSIONS) + buildName), (Object)StringUtils.stringToBytes((String)latestVersion)));
        this.store.putWithStrings(values);
    }

    public Map<String, String> getLatestBuildsVersions() throws StorageException {
        HashMap<String, String> result = new HashMap<String, String>();
        PairList rawEntries = this.store.getEntriesStartingWith(EStorePrefix.LATEST_BUILD_VERSIONS.prefix);
        for (int i = 0; i < rawEntries.size(); ++i) {
            String buildName = StringUtils.bytesToString((byte[])((byte[])rawEntries.getFirst(i)));
            String latestVersion = StringUtils.bytesToString((byte[])((byte[])rawEntries.getSecond(i)));
            result.put(StringUtils.stripPrefix((String)buildName, (String)EStorePrefix.LATEST_BUILD_VERSIONS.prefix), latestVersion);
        }
        return result;
    }

    public void deleteIgnoreRules(List<String> ignoreRuleIds) throws StorageException {
        this.store.removeWithStrings(ignoreRuleIds.stream().map(id -> String.valueOf((Object)EStorePrefix.IGNORE_RULES) + id).toList());
    }

    public void deleteAllVersionsForBuildNames(List<String> buildsNamesToDelete) throws StorageException {
        List deleteKeys = (List)buildsNamesToDelete.stream().map(buildName -> String.valueOf((Object)EStorePrefix.BUILDS) + buildName + "#-#").collect(CollectionUtils.toArrayList());
        deleteKeys.addAll(buildsNamesToDelete.stream().map(buildName -> String.valueOf((Object)EStorePrefix.BUILD_VERSIONS) + buildName + "#-#").toList());
        deleteKeys.addAll(buildsNamesToDelete.stream().map(buildName -> String.valueOf((Object)EStorePrefix.LATEST_BUILD_VERSIONS) + buildName).toList());
        deleteKeys.addAll(buildsNamesToDelete.stream().map(buildName -> String.valueOf((Object)EStorePrefix.SCAN_RESULTS) + buildName).toList());
        for (String deleteKey : deleteKeys) {
            this.store.removeByPrefix(deleteKey);
        }
    }

    private static enum EStorePrefix {
        BUILDS("b"),
        BUILD_VERSIONS("v"),
        LATEST_BUILD_VERSIONS("n"),
        IGNORE_RULES("i"),
        BUILD_CODE_REVISIONS("c"),
        SCAN_RESULTS("s");

        private static final String SEPARATOR = "#-#";
        private final String prefix;

        private EStorePrefix(String prefix) {
            this.prefix = prefix + SEPARATOR;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

