/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sca.jfrog;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.repository.sca.BuildComponent;
import com.teamscale.index.repository.sca.BuildInfo;
import com.teamscale.index.repository.sca.BuildScanResult;
import com.teamscale.index.repository.sca.BuildVersion;
import com.teamscale.index.repository.sca.CompositionViolation;
import com.teamscale.index.repository.sca.CompositionVulnerability;
import com.teamscale.index.repository.sca.CveInfo;
import com.teamscale.index.repository.sca.IgnoreRuleApprovalState;
import com.teamscale.index.repository.sca.IgnoreViolationRequest;
import com.teamscale.index.repository.sca.IgnoreViolationRule;
import com.teamscale.index.repository.sca.NameWithVersion;
import com.teamscale.index.repository.sca.jfrog.JFrogClasses;
import com.teamscale.index.repository.sca.jfrog.JFrogXrayIndex;
import com.teamscale.index.repository.sca.jfrog.JfrogXrayClient;
import com.teamscale.index.webhook.XrayBuildsWebhookPayload;
import com.teamscale.index.webhook.XrayBuildsWebhookUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class JFrogXraySynchronizer
extends ChangeRetrieverAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="account-identifier")
    private String accountIdentifier;
    @StepParameter(value="JFrog Project Keys")
    private Set<String> xrayProjectKeys;
    @StepParameter(value="Build Include Patterns")
    private List<String> buildIncludePatterns;
    @StepParameter(value="Build Exclude Patterns")
    private List<String> buildExcludePatterns;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex externalCredentialsIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private JFrogXrayIndex jfrogXrayIndex;
    private String jfrogUrl;

    private @Nullable ExternalCredentials getExternalCredentials() throws StorageException {
        ExternalCredentials externalCredentials;
        try {
            externalCredentials = this.externalCredentialsIndex.getExternalCredentials(this.accountIdentifier);
        }
        catch (StorageException e) {
            throw new StorageException("Account '" + this.accountIdentifier + "' could not be retrieved.", (Throwable)e);
        }
        return externalCredentials;
    }

    protected @Nullable CommitDescriptor executeAndReturnCommitResult() throws StorageException {
        if (this.xrayProjectKeys.isEmpty()) {
            LOGGER.error("Empty list for Xray project keys in project configuration. Skipping synchronization");
            return null;
        }
        JfrogXrayClient.RJFrogRetrofitApi client = this.initializeJFrogClient();
        try {
            this.executeInParallelBatches(new ArrayList<String>(this.xrayProjectKeys), projects -> this.processXrayProjects(client, (String)projects.get(0)), 1);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void processXrayProjects(JfrogXrayClient.RJFrogRetrofitApi client, String projectKey) throws StorageException {
        try {
            this.processProjectBuilds(client, projectKey);
        }
        catch (IOException | ExecutionException e) {
            LOGGER.error("Error while retrieving build data from JFrog Xray", (Throwable)e);
        }
        try {
            this.loadRulesForIgnoredViolations(client, projectKey);
        }
        catch (IOException | StorageException e) {
            LOGGER.error("Error while loading ignore rules for Xray project '{}'", (Object)projectKey, (Object)e);
        }
    }

    private void processProjectBuilds(JfrogXrayClient.RJFrogRetrofitApi client, String projectKey) throws StorageException, ExecutionException, IOException {
        HashMap<NameWithVersion, JFrogClasses.XrayBuildInfo> buildsByVersion = new HashMap<NameWithVersion, JFrogClasses.XrayBuildInfo>();
        HashSet seenBuildKeys = new HashSet();
        int buildOffset = 0;
        ArrayList<String> excludedBuildNames = new ArrayList<String>();
        while (true) {
            LOGGER.debug("Loading Xray builds with offset {}", (Object)buildOffset);
            JfrogXrayClient.BuildsResponse buildsResponse = (JfrogXrayClient.BuildsResponse)client.getXrayBuilds(buildOffset, JfrogXrayClient.determineXrayApiProjectKey(projectKey)).execute().body();
            if (buildsResponse == null || CollectionUtils.emptyIfNull(buildsResponse.data()).isEmpty()) break;
            List buildsInXray = CollectionUtils.emptyIfNull(buildsResponse.data());
            LOGGER.debug("New builds offset {}", (Object)(buildOffset += buildsResponse.data().size()));
            buildsInXray.forEach(build -> {
                if (this.isExcludedByPatterns(build.name())) {
                    excludedBuildNames.add(build.name());
                    return;
                }
                String buildKey = build.name() + "@" + build.latestVersion() + "@" + build.buildRepository();
                if (seenBuildKeys.contains(buildKey)) {
                    LOGGER.warn("Internal: Already saw build {}, check if pagination works correctly", (Object)buildKey);
                    return;
                }
                seenBuildKeys.add(buildKey);
                buildsByVersion.put(new NameWithVersion(build.name(), build.latestVersion()), (JFrogClasses.XrayBuildInfo)build);
            });
        }
        LOGGER.debug("Received empty build list, existing");
        Map<NameWithVersion, BuildInfo> knownBuilds = this.jfrogXrayIndex.getBuilds(buildsByVersion.keySet());
        ArrayList newOrUpdatedBuilds = new ArrayList();
        buildsByVersion.forEach((buildNameAndVersion, build) -> {
            if (!knownBuilds.containsKey(buildNameAndVersion) || knownBuilds.get(buildNameAndVersion) == null || !((BuildInfo)knownBuilds.get(buildNameAndVersion)).updatedAt().equals(build.updatedAt())) {
                newOrUpdatedBuilds.add(build);
            }
        });
        if (newOrUpdatedBuilds.isEmpty()) {
            return;
        }
        this.jfrogXrayIndex.storeBuilds(newOrUpdatedBuilds.stream().map(jfrogBuild -> BuildInfo.forJfrogBuild(jfrogBuild, this.jfrogUrl, projectKey)).toList());
        this.executeInParallelBatches(newOrUpdatedBuilds, batch -> this.processXrayBuildBatch((List<JFrogClasses.XrayBuildInfo>)batch, client, projectKey), 3);
        this.jfrogXrayIndex.deleteAllVersionsForBuildNames(excludedBuildNames);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isExcludedByPatterns(String buildName) {
        if (!this.buildExcludePatterns.isEmpty()) {
            if (this.buildExcludePatterns.stream().anyMatch(buildName::matches)) {
                return true;
            }
        }
        if (this.buildIncludePatterns.isEmpty()) return false;
        if (!this.buildIncludePatterns.stream().noneMatch(buildName::matches)) return false;
        return true;
    }

    private JfrogXrayClient.RJFrogRetrofitApi initializeJFrogClient() throws StorageException {
        ExternalCredentials externalCredentials = this.getExternalCredentials();
        if (externalCredentials == null) {
            throw new StorageException("No external account found.");
        }
        if (StringUtils.isEmpty((String)externalCredentials.uri)) {
            throw new StorageException("URL must not be empty in account " + this.accountIdentifier);
        }
        this.jfrogUrl = externalCredentials.uri;
        String accessToken = externalCredentials.password;
        try {
            return new JfrogXrayClient(this.jfrogUrl, accessToken).getClient();
        }
        catch (IOException e) {
            throw new StorageException("Error initializing JFrog client", (Throwable)e);
        }
    }

    private void loadRulesForIgnoredViolations(JfrogXrayClient.RJFrogRetrofitApi client, String projectKey) throws StorageException, IOException {
        JFrogClasses.IgnoreRulesResponse ignoreRulesResponse = (JFrogClasses.IgnoreRulesResponse)client.getIgnoreRules(JfrogXrayClient.determineXrayApiProjectKey(projectKey)).execute().body();
        if (ignoreRulesResponse == null) {
            LOGGER.warn("Received null-response for ignore rules for project {}", (Object)projectKey);
            return;
        }
        ArrayList<IgnoreViolationRule> convertedIgnoreRules = new ArrayList<IgnoreViolationRule>();
        for (JFrogClasses.XrayViolationRule xrayViolationRule : CollectionUtils.emptyIfNull(ignoreRulesResponse.data())) {
            JfrogXrayClient.IgnoreRuleRequest.IgnoreFilters filters = xrayViolationRule.ignoreFilters();
            List targetProjects = CollectionUtils.emptyIfNull(filters.projectKeys());
            if (targetProjects.isEmpty() && !projectKey.equals("artifactory") || !targetProjects.isEmpty() && !targetProjects.contains(projectKey)) continue;
            String xrayIssueId = null;
            if (!filters.vulnerabilities().isEmpty() && !filters.vulnerabilities().contains("any")) {
                xrayIssueId = filters.vulnerabilities().getFirst();
            }
            String watchName = null;
            if (!CollectionUtils.emptyIfNull(filters.watches()).isEmpty() && !CollectionUtils.emptyIfNull(filters.watches()).contains("any")) {
                watchName = filters.watches().getFirst();
            }
            NameWithVersion build = null;
            if (!filters.builds().isEmpty() && filters.builds().stream().noneMatch(b -> b.name().equals("any")) && (build = filters.builds().getFirst()).version().equals("any")) {
                build = new NameWithVersion(build.name(), "");
            }
            convertedIgnoreRules.add(new IgnoreViolationRule(null, xrayViolationRule.id(), xrayViolationRule.created(), xrayViolationRule.notes(), xrayViolationRule.expiresAt(), new IgnoreViolationRequest(this.accountIdentifier, null, xrayViolationRule.notes(), CollectionUtils.emptyIfNull(filters.components()), build, xrayIssueId, watchName, projectKey), xrayViolationRule.id(), projectKey, this.accountIdentifier, new IgnoreRuleApprovalState(FindingBlacklistEvent.EExtendedBlacklistChangeType.EXCLUSION, null, null, null)));
        }
        this.jfrogXrayIndex.storeIgnoreRules(convertedIgnoreRules);
        Set allIgnoreRuleIdsInXray = CollectionUtils.emptyIfNull(ignoreRulesResponse.data()).stream().map(JFrogClasses.XrayViolationRule::id).collect(Collectors.toSet());
        List<IgnoreViolationRule> allIgnoreRules = this.jfrogXrayIndex.getIgnoreRules();
        List<String> ignoreRuleIdsNoLongerPresentInXray = allIgnoreRules.stream().filter(ignoreRule -> projectKey.equals(ignoreRule.xrayProjectKey())).filter(ignoreRule -> ignoreRule.xrayRuleId() != null && !allIgnoreRuleIdsInXray.contains(ignoreRule.xrayRuleId())).map(IgnoreViolationRule::id).toList();
        this.jfrogXrayIndex.deleteIgnoreRules(ignoreRuleIdsNoLongerPresentInXray);
    }

    private void processXrayBuildBatch(List<JFrogClasses.XrayBuildInfo> buildsInBatch, JfrogXrayClient.RJFrogRetrofitApi client, String projectKey) {
        BuildScanData scanData = new BuildScanData();
        try {
            List<BuildScanResult> existingScanResultsForBuilds = this.jfrogXrayIndex.getScanResultsForBuilds(buildsInBatch.stream().map(build -> new NameWithVersion(build.name(), build.latestVersion())).toList());
            HashSet<String> seenVersions = new HashSet<String>();
            for (JFrogClasses.XrayBuildInfo build2 : buildsInBatch) {
                JfrogXrayClient.BuildsVersionsResponse versionsResponse;
                scanData.newestVersionByBuildName.put(build2.name(), build2.latestVersion());
                ArrayList<JFrogClasses.XrayBuildVersion> allVersionsForThisBuild = new ArrayList<JFrogClasses.XrayBuildVersion>();
                int versionsOffset = 0;
                do {
                    this.verifyNotCanceled();
                    versionsResponse = (JfrogXrayClient.BuildsVersionsResponse)client.getBuildVersions(JFrogXraySynchronizer.toBase64(build2.name()), build2.buildRepository(), versionsOffset, JfrogXrayClient.determineXrayApiProjectKey(projectKey)).execute().body();
                    if (versionsResponse == null || CollectionUtils.emptyIfNull(versionsResponse.data()).isEmpty()) break;
                    List<String> versionStrings = versionsResponse.data().stream().map(JFrogClasses.XrayBuildVersion::version).toList();
                    for (String versionString : versionStrings) {
                        if (seenVersions.contains(versionString)) {
                            LOGGER.warn("Internal: Already saw version {} @ {} in this batch, check pagination", (Object)build2.name(), (Object)versionString);
                        }
                        seenVersions.add(versionString);
                    }
                    allVersionsForThisBuild.addAll(versionsResponse.data());
                    versionsOffset += versionsResponse.data().size();
                } while (versionsResponse.offset() != -1);
                ArrayList<BuildVersion> buildVersions = JFrogXraySynchronizer.convertBuildVersions(allVersionsForThisBuild);
                LOGGER.debug("Loaded {} versions for build {}:\n{}", (Object)allVersionsForThisBuild.size(), (Object)build2.name(), (Object)allVersionsForThisBuild.stream().map(JFrogClasses.XrayBuildVersion::version).collect(Collectors.joining(", ")));
                if (buildVersions.isEmpty()) {
                    LOGGER.warn("No build versions for {} in repository {}", (Object)build2.name(), (Object)build2.buildRepository());
                    break;
                }
                this.processBuildVersions(client, build2, buildVersions, existingScanResultsForBuilds, scanData, projectKey);
                scanData.buildNamesWithVersions.add((Object)build2.name(), buildVersions);
            }
            this.jfrogXrayIndex.storeBuildVersions(scanData.buildNamesWithVersions);
            this.jfrogXrayIndex.storeScanResultsForBuilds(scanData.scanResults);
            this.jfrogXrayIndex.storeCommitHashesForBuild(scanData.buildsToCommitHashes);
            this.jfrogXrayIndex.storeLatestBuildVersions(scanData.newestVersionByBuildName);
            this.triggerViolationsWebhook(scanData);
        }
        catch (IOException | ExecutionCanceledException | StorageException e) {
            LOGGER.error("Error processing Xray builds", e);
        }
    }

    private static ArrayList<BuildVersion> convertBuildVersions(@Nullable List<JFrogClasses.XrayBuildVersion> versions) {
        if (CollectionUtils.isNullOrEmpty(versions)) {
            return new ArrayList<BuildVersion>();
        }
        return (ArrayList)versions.stream().map(xrayVersion -> {
            String scanStatus = "";
            String scanDate = "";
            if (xrayVersion.scanStatus() != null && xrayVersion.scanStatus().overall() != null) {
                scanStatus = xrayVersion.scanStatus().overall().status();
                scanDate = xrayVersion.scanStatus().overall().time();
            }
            int securityIssuesCount = xrayVersion.sec_issues() == null ? 0 : xrayVersion.sec_issues().total();
            return new BuildVersion(xrayVersion.version(), xrayVersion.violations(), xrayVersion.created_at(), xrayVersion.status(), xrayVersion.componentId(), securityIssuesCount, xrayVersion.package_id(), scanStatus, scanDate);
        }).collect(CollectionUtils.toArrayList());
    }

    private void processBuildVersions(JfrogXrayClient.RJFrogRetrofitApi client, JFrogClasses.XrayBuildInfo xrayBuildInfo, ArrayList<BuildVersion> buildVersions, List<BuildScanResult> existingScanResultsForBuilds, BuildScanData scanData, String projectKey) {
        for (BuildVersion buildVersion : buildVersions) {
            NameWithVersion buildDescriptor = new NameWithVersion(xrayBuildInfo.name(), buildVersion.version());
            LOGGER.debug("Processing build version {} @ {}", (Object)buildDescriptor.name(), (Object)buildVersion.version());
            try {
                long lastScanTimestampInXray = 0L;
                if (buildVersion.scanStatus() != null) {
                    lastScanTimestampInXray = Instant.parse(buildVersion.scanDate()).toEpochMilli();
                }
                if (!existingScanResultsForBuilds.isEmpty() && existingScanResultsForBuilds.getFirst() != null && existingScanResultsForBuilds.getFirst().lastScanTimestamp() == lastScanTimestampInXray) {
                    LOGGER.info("Skipping processing for build {} due to unchanged last scan timestamp {}", (Object)xrayBuildInfo.name(), (Object)lastScanTimestampInXray);
                    continue;
                }
                if (buildVersion.scanStatus() == null || !buildVersion.scanStatus().equalsIgnoreCase("done")) {
                    LOGGER.info("Skipping processing for build {} because build status is {}", (Object)xrayBuildInfo.name(), (Object)buildVersion.scanStatus());
                    continue;
                }
                JFrogClasses.BuildSummary buildSummary = (JFrogClasses.BuildSummary)client.getBuildSummary(xrayBuildInfo.name(), buildVersion.version(), xrayBuildInfo.buildRepository(), JfrogXrayClient.determineXrayApiProjectKey(projectKey)).execute().body();
                ArrayList<JfrogXrayClient.XrayViolation> loadedViolations = new ArrayList<JfrogXrayClient.XrayViolation>();
                int violationsPage = 1;
                while (true) {
                    this.verifyNotCanceled();
                    LOGGER.debug("Loading violations for {} @ {}, page {}", (Object)buildDescriptor.name(), (Object)buildVersion.version(), (Object)violationsPage);
                    JFrogClasses.XrayListResponse allViolations = (JFrogClasses.XrayListResponse)client.getAllViolations(JfrogXrayClient.ViolationFilter.forBuild(buildDescriptor.name(), buildDescriptor.version(), xrayBuildInfo.buildRepository()), violationsPage, JfrogXrayClient.determineXrayApiProjectKey(projectKey)).execute().body();
                    UnmodifiableList thisBatch = allViolations == null ? CollectionUtils.emptyList() : CollectionUtils.emptyIfNull(allViolations.data());
                    loadedViolations.addAll((Collection<JfrogXrayClient.XrayViolation>)thisBatch);
                    if (thisBatch.isEmpty() || loadedViolations.size() >= allViolations.totalCount()) break;
                    ++violationsPage;
                }
                LOGGER.debug("Loaded {} violations for {}", (Object)loadedViolations.size(), (Object)buildVersion);
                List<CompositionViolation> violations = this.convertViolations(loadedViolations, buildDescriptor, projectKey);
                scanData.scanResults.add(new BuildScanResult(lastScanTimestampInXray, JFrogXraySynchronizer.convertVulnerabilities(buildSummary), violations, buildDescriptor));
                JFrogClasses.BuildDetails buildInfo = (JFrogClasses.BuildDetails)client.getBuildDetails(xrayBuildInfo.name(), buildVersion.version(), JfrogXrayClient.determineXrayApiProjectKey(projectKey)).execute().body();
                if (buildInfo == null || buildInfo.buildInfo() == null || CollectionUtils.emptyIfNull(buildInfo.buildInfo().vcs()).isEmpty()) continue;
                scanData.buildsToCommitHashes.add((Object)buildDescriptor, (Object)((ArrayList)buildInfo.buildInfo().vcs().stream().map(JFrogClasses.Vcs::revision).collect(CollectionUtils.toArrayList())));
            }
            catch (Exception e) {
                LOGGER.error("Error processing version {} of {} ,  skipping", (Object)buildVersion.version(), (Object)xrayBuildInfo.name(), (Object)e);
            }
        }
    }

    private List<CompositionViolation> convertViolations(List<JfrogXrayClient.XrayViolation> xrayViolations, NameWithVersion buildDescriptor, String xrayProjectKey) {
        return (List)xrayViolations.stream().map(xrayViolation -> new CompositionViolation(buildDescriptor, xrayViolation.issue_id(), xrayViolation.summary(), xrayViolation.severity(), xrayViolation.type(), xrayViolation.updated(), xrayViolation.watcher_name(), this.accountIdentifier, xrayViolation.sources().stream().map(source -> new BuildComponent(source.source(), source.source_version(), source.source_id())).toList(), xrayProjectKey)).collect(CollectionUtils.toArrayList());
    }

    private static List<CompositionVulnerability> convertVulnerabilities(JFrogClasses.BuildSummary buildSummary) {
        if (buildSummary == null || CollectionUtils.isNullOrEmpty(buildSummary.issues())) {
            return CollectionUtils.emptyList();
        }
        return buildSummary.issues().stream().map(xrayIssue -> new CompositionVulnerability(xrayIssue.issueId(), xrayIssue.summary(), xrayIssue.description(), xrayIssue.issueType(), xrayIssue.severity(), xrayIssue.provider(), xrayIssue.created(), CollectionUtils.emptyIfNull(xrayIssue.impactPath()), JFrogXraySynchronizer.convertCveInfo(CollectionUtils.emptyIfNull(xrayIssue.cves())), CollectionUtils.emptyIfNull(xrayIssue.componentPhysicalPaths()))).toList();
    }

    private static List<CveInfo> convertCveInfo(List<JFrogClasses.XrayCve> cves) {
        return cves.stream().map(xrayCve -> new CveInfo(StringUtils.emptyIfNull((String)xrayCve.cve()), CollectionUtils.emptyIfNull(xrayCve.cwe()), StringUtils.emptyIfNull((String)xrayCve.cvss_v2()), StringUtils.emptyIfNull((String)xrayCve.cvss_v3()))).toList();
    }

    private static String toBase64(String buildName) {
        return Base64.getEncoder().encodeToString(buildName.getBytes(StandardCharsets.UTF_8));
    }

    private void triggerViolationsWebhook(BuildScanData scanData) throws StorageException {
        List builds = CollectionUtils.map(scanData.scanResults, BuildScanResult::build);
        XrayBuildsWebhookUtils.triggerWebhook(this.serverOptionIndex, new XrayBuildsWebhookPayload(this.getProjectId().toString(), builds));
    }

    private record BuildScanData(List<BuildScanResult> scanResults, Map<String, String> newestVersionByBuildName, PairList<NameWithVersion, ArrayList<String>> buildsToCommitHashes, PairList<String, ArrayList<BuildVersion>> buildNamesWithVersions) {
        BuildScanData() {
            this(new ArrayList<BuildScanResult>(), new HashMap<String, String>(), (PairList<NameWithVersion, ArrayList<String>>)new PairList(), (PairList<String, ArrayList<BuildVersion>>)new PairList());
        }
    }
}

