/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors.codebeamer;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.connectors.authentication.CredentialsConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.rest.HttpRequestRetryStepParameters;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.IExternalToolLinkRoleResolver;
import com.teamscale.index.issues.IExternalToolLinkRoleResolverProvider;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.codebeamer.client.ICodebeamerClient;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.index.requirements_tracing.tools.codebeamer.CodebeamerLinkResolver;
import com.teamscale.index.requirements_tracing.triggers.codebeamer.CodebeamerSpecItemSynchronizer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@ConnectorDescriptor
public class CodebeamerRequirementsManagementToolConnectorDescriptor
extends RequirementsManagementToolConnectorDescriptorBase
implements IExternalToolLinkRoleResolverProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CODEBEAMER_PROJECT_NAMES_PARAMETER_NAME = "Project Names";
    @ConfigExposed(name="Project Names", description="Comma separated list of the names of projects to import items from.")
    protected Set<String> projectNames = new HashSet<String>();
    public static final String CODEBEAMER_TRACKER_NAMES_PARAMETER_NAME = "Tracker Names";
    @ConfigExposed(name="Tracker Names", description="Comma separated list of the names of trackers to import items from.")
    protected Set<String> trackerNames = new HashSet<String>();
    public static final String CODEBEAMER_TRACKER_TO_TYPE_MAPPING = "Tracker to Types Mapping";
    @ConfigExposed(name="Tracker to Types Mapping", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Defines a mapping from the tracker name to a certain type, e.g. 'MyBugTracker -> Bug, MyTaskTracker -> Task'. This overrides the type of items retrieved from the tracker.")
    private PairList<String, String> trackerNameToTypeMapping = new PairList();
    public static final String CODEBEAMER_INCLUDED_TRACKER_TYPES_PARAMETER_NAME = "Tracker Types";
    @ConfigExposed(name="Tracker Types", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The types of trackers to retrieve items from. Leave empty for all tracker types. Specify type abbreviations after the arrow symbol.")
    private PairList<String, String> includedTrackerTypes = CodebeamerRequirementsManagementToolConnectorDescriptor.getDefaultIncludedTrackerItemTypes();
    public static final String CODEBEAMER_INCLUDED_TRACKER_ITEM_CATEGORIES_PARAMETER_NAME = "Tracker Item Categories";
    @ConfigExposed(name="Tracker Item Categories", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The categories of tracker items to retrieve. Leave empty for all tracker item categories.")
    private Set<String> includedTrackerItemCategories = new HashSet<String>();
    private static final String CODE_BEAMER_SERVER_TIME_ZONE_PARAMETER_NAME = "CodeBeamer Server Time Zone";
    @ConfigExposed(name="CodeBeamer Server Time Zone", description="The time zone of the Codebeamer server, e.g. \"Europe/Berlin\" or \"America/New_York\".\nUnfortunately, Codebeamer only uses local date-time values when transmitting work items, which could result in incorrect timestamps within Teamscale.\nIf not set, Teamscale assumes the Codebeamer server uses the same time zone as Teamscale.\n", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private String codebeamerTimeZone = "";
    @ConfigExposed(name="Item types representing test items", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Item types (or the abbreviation) that represent test items, which Teamscale should parse and treat as tests.")
    private List<String> itemTypesRepresentingTestCases = List.of("Testcase");
    @StepParameterObject
    private final HttpRequestRetryStepParameters retryPolicy = new HttpRequestRetryStepParameters();
    @ConfigExposed(name="Remove deleted items", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Whether tracker items deleted in Codebeamer should also be deleted in Teamscale. If enabled, the first poll per day will also check for tracker items deleted in Codebeamer and remove them from Teamscale. In order to detect deleted tracker items, every tracker item has to be fetched from the Codebeamer server. This can be a rather expensive operation, even when no tracker items are deleted. ", changeRequiresReAnalysis=false)
    private boolean cleanupEnabled = true;
    @ExposeConnectorModule
    protected final CredentialsConnectorModule credentialsModule = new CredentialsConnectorModule(this::validateAccountDetails, false);

    private static PairList<String, String> getDefaultIncludedTrackerItemTypes() {
        PairList result = new PairList();
        result.add((Object)"Bug", (Object)"Bug");
        result.add((Object)"Task", (Object)"Task");
        result.add((Object)"User Story", (Object)"US");
        result.add((Object)"Testcase", (Object)"Test Case");
        return result;
    }

    protected CodebeamerRequirementsManagementToolConnectorDescriptor() {
        super(ERequirementsManagementTool.CODEBEAMER);
        this.autoExpose();
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if (!StringUtils.isEmpty((String)this.codebeamerTimeZone)) {
            try {
                ZoneId.of(this.codebeamerTimeZone);
            }
            catch (DateTimeException e) {
                throw new ConnectorValidationException("Unknown %s: %s".formatted(CODE_BEAMER_SERVER_TIME_ZONE_PARAMETER_NAME, this.codebeamerTimeZone), (Throwable)e);
            }
        }
    }

    @Override
    public IExternalToolLinkRoleResolver getLinkRoleResolver() throws ConnectorValidationException {
        super.validate();
        ExternalCredentials externalCredentials = this.credentialsModule.resolveExternalCredentials(this.getContext().getExternalCredentialsProvider());
        return new CodebeamerLinkResolver((ICodebeamerClient)Retrofit.builder((String)externalCredentials.uri).withBasicNTLMAuthentication(externalCredentials.username, externalCredentials.password).withInteractionLogger(LOGGER).withRetryPolicy(this.retryPolicy.createRetryPolicy()).create(ICodebeamerClient.class));
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return CodebeamerSpecItemSynchronizer.class;
    }

    private void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        ICodebeamerClient codebeamerClient = (ICodebeamerClient)Retrofit.builder((String)url).withBasicNTLMAuthentication(username, password).withInteractionLogger(LOGGER).withRetryPolicy(this.retryPolicy.createRetryPolicy()).create(ICodebeamerClient.class);
        try {
            codebeamerClient.getProjects().execute();
        }
        catch (IOException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    public String getAccountIdentifier() {
        return this.credentialsModule.getCredentialsName();
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter(CODEBEAMER_PROJECT_NAMES_PARAMETER_NAME, ITriggerParameter.of(this.projectNames));
        issueTrackerTriggerBuilder.setTriggerParameter(CODEBEAMER_TRACKER_NAMES_PARAMETER_NAME, ITriggerParameter.of(this.trackerNames));
        issueTrackerTriggerBuilder.setTriggerParameter(CODEBEAMER_INCLUDED_TRACKER_ITEM_CATEGORIES_PARAMETER_NAME, ITriggerParameter.of(this.includedTrackerItemCategories));
        issueTrackerTriggerBuilder.setTriggerParameter("Spec Item types to analyse", ITriggerParameter.of((Object)this.itemTypesToAnalyze));
        issueTrackerTriggerBuilder.setTriggerParameter(CODEBEAMER_INCLUDED_TRACKER_TYPES_PARAMETER_NAME, ITriggerParameter.of(this.includedTrackerTypes));
        issueTrackerTriggerBuilder.setTriggerParameter(CODEBEAMER_TRACKER_TO_TYPE_MAPPING, ITriggerParameter.of(this.trackerNameToTypeMapping));
        issueTrackerTriggerBuilder.setTriggerParameter("item-types-representing-test-cases", ITriggerParameter.of(this.itemTypesRepresentingTestCases));
        issueTrackerTriggerBuilder.setTriggerParameter("cleanup-enabled", this.cleanupEnabled);
        if (!StringUtils.isEmpty((String)this.codebeamerTimeZone)) {
            issueTrackerTriggerBuilder.setTriggerParameter("server-time-zone", this.codebeamerTimeZone);
        }
        issueTrackerTriggerBuilder.renameIndex("work-item-cleanup-index", WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }
}

