/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.element_details;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@IndexValueClass
public class CodeScopeDetail
extends TokenElementDetailBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final CodeScopeName codeScopeName;

    public CodeScopeDetail(CodeScopeName codeScopeName) {
        this.codeScopeName = codeScopeName;
    }

    public CodeScopeName getCodeScopeName() {
        return this.codeScopeName;
    }

    public static CodeScopeName getCodeScopeNameFromTokenElement(BasicTokenElementInfo tokenElementInfo) {
        String uniformPathString;
        UniformPath uniformPath;
        Optional codeScopeDetail = tokenElementInfo.getFirstDetailOfType(CodeScopeDetail.class);
        if (codeScopeDetail.isEmpty() && (uniformPath = UniformPathCompatibilityUtil.convert((String)(uniformPathString = tokenElementInfo.getUniformPath()))).isCodePath() && !UniformPathUtils.isArchitectureFile((String)uniformPathString)) {
            LOGGER.error("No code scope detail present for uniform code path '%s'. A missing code scope for a code path hints towards a code location where token elements are written without explicit code scope assignment. Please reach out to the Teamscale support or write a bug ticket as every code-related token element should be assigned to a code scope.".formatted(uniformPathString));
        }
        return codeScopeDetail.map(CodeScopeDetail::getCodeScopeName).orElse(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public static CodeScopeDetail createForDefaultCodeScope() {
        return new CodeScopeDetail(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public static void verifyCodeScopeDetail(BasicTokenElementInfo tokenElement) {
        CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElement);
    }
}

