/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.resolution_strategy;

import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.resolution_strategy.CodeResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.IssueItemResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.NonCodeResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.SpecItemResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.StoredQueryResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.TestResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.VirtualFileSystemResourceResolutionStrategy;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ResourceResolutionStrategyFactory {
    public static IResourceResolutionStrategy getStrategy(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem) {
        UniformPath.EType uniformPathType = uniformPath.getType();
        return switch (uniformPathType) {
            default -> throw new MatchException(null, null);
            case UniformPath.EType.ISSUE_QUERY -> new StoredQueryResourceResolutionStrategy(projectStorageSystem, StoredQueryIndex.EStoredQueryType.ISSUE);
            case UniformPath.EType.SPEC_ITEM_QUERY -> new StoredQueryResourceResolutionStrategy(projectStorageSystem, StoredQueryIndex.EStoredQueryType.SPEC_ITEM);
            case UniformPath.EType.TEST_QUERY -> new StoredQueryResourceResolutionStrategy(projectStorageSystem, StoredQueryIndex.EStoredQueryType.TEST);
            case UniformPath.EType.NON_CODE -> new NonCodeResourceResolutionStrategy(projectStorageSystem);
            case UniformPath.EType.TEST_IMPLEMENTATION, UniformPath.EType.TEST_EXECUTION, UniformPath.EType.EXECUTION_UNIT -> new TestResourceResolutionStrategy(projectStorageSystem);
            case UniformPath.EType.CODE -> new CodeResourceResolutionStrategy(projectStorageSystem);
            case UniformPath.EType.ARCHITECTURE, UniformPath.EType.CODE_SCOPES -> new VirtualFileSystemResourceResolutionStrategy(projectStorageSystem);
            case UniformPath.EType.SPEC_ITEM -> new SpecItemResourceResolutionStrategy(projectStorageSystem);
            case UniformPath.EType.ISSUE_ITEM -> new IssueItemResourceResolutionStrategy(projectStorageSystem, uniformPathType);
        };
    }
}

