/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.resolution_strategy;

import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.utils.EResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class StoredQueryResourceResolutionStrategy
implements IResourceResolutionStrategy {
    private final ProjectStorageSystem projectStorageSystem;
    private final StoredQueryIndex.EStoredQueryType storedQueryType;

    public StoredQueryResourceResolutionStrategy(ProjectStorageSystem projectStorageSystem, StoredQueryIndex.EStoredQueryType storedQueryType) {
        this.projectStorageSystem = projectStorageSystem;
        this.storedQueryType = storedQueryType;
    }

    @Override
    public ContainerInfo getContainerInfoForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.getContainerInfoForPath(uniformPath.toString(), this.openIndex());
    }

    @Override
    public List<ContainerInfo> getContainerInfosForPaths(List<UniformPath> uniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        ArrayList<ContainerInfo> containerInfos = new ArrayList<ContainerInfo>();
        for (UniformPath uniformPath : uniformPaths) {
            containerInfos.add(this.getContainerInfoForPath(uniformPath, null));
        }
        return containerInfos;
    }

    @Override
    public EResourceType getResourceTypeForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.getResourceTypeForPath(uniformPath.toString(), this.openIndex());
    }

    @Override
    public Map<String, EResourceType> getResourceChildTypesForPath(UniformPath uniformPath, boolean includeChildFullPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.getChildResourceTypesForPath(uniformPath.toString(), includeChildFullPath, this.openIndex());
    }

    private ContainerInfo getContainerInfoForPath(String path, StoredQueryIndex index) throws StorageException {
        Set<String> names = this.getNamesForPath(path, index);
        if (StoredQueryResourceResolutionStrategy.isEmptyOrContainsExactly(names, path)) {
            return null;
        }
        Map<String, List<String>> grouped = names.stream().collect(Collectors.groupingBy(name -> StoredQueryResourceResolutionStrategy.extractRelativePlainName(path, name)));
        ContainerInfo container = new ContainerInfo(path);
        for (Map.Entry<String, List<String>> entry : grouped.entrySet()) {
            StoredQueryResourceResolutionStrategy.appendContainerEntry(entry.getKey(), entry.getValue(), path, container);
        }
        return container;
    }

    private <T extends Serializable> EResourceType getResourceTypeForPath(String path, StoredQueryIndex index) throws StorageException {
        if (this.getPathPrefix().equals(path)) {
            if (index.getAllQueryNames().isEmpty()) {
                return EResourceType.UNKNOWN;
            }
            return EResourceType.CONTAINER;
        }
        Set<String> names = this.getNamesForPath(path, index);
        if (names.isEmpty()) {
            return EResourceType.UNKNOWN;
        }
        if (names.size() == 1 && names.contains(path)) {
            return EResourceType.FILE;
        }
        return EResourceType.CONTAINER;
    }

    private <T extends Serializable> Map<String, EResourceType> getChildResourceTypesForPath(String path, boolean includeChildFullPath, StoredQueryIndex index) throws StorageException {
        Set<String> queryNames = this.getNamesForPath(path, index);
        if (StoredQueryResourceResolutionStrategy.isEmptyOrContainsExactly(queryNames, path)) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> groupedByPlainName = queryNames.stream().collect(Collectors.groupingBy(name -> StoredQueryResourceResolutionStrategy.extractRelativePlainName(path, name)));
        HashMap<String, EResourceType> result = new HashMap<String, EResourceType>();
        for (Map.Entry<String, List<String>> plainNameWithPaths : groupedByPlainName.entrySet()) {
            String elementPath = path + UniformPathUtils.SEPARATOR + plainNameWithPaths.getKey();
            List<String> pathsForPlainName = plainNameWithPaths.getValue();
            EResourceType resourceType = EResourceType.CONTAINER;
            if (pathsForPlainName.size() == 1 && elementPath.equals(pathsForPlainName.get(0))) {
                resourceType = EResourceType.FILE;
            }
            result.put(StoredQueryResourceResolutionStrategy.determineCorrectEntryName(elementPath, path, includeChildFullPath), resourceType);
        }
        return result;
    }

    private <T extends Serializable> Set<String> getNamesForPath(String path, StoredQueryIndex index) throws StorageException {
        List<String> keys;
        Set<String> names;
        String pathPrefix = this.getPathPrefix();
        String pathPrefixWithSeparator = this.getPathPrefixWithSeparator();
        if (pathPrefix.equals(path)) {
            path = pathPrefixWithSeparator;
        }
        if (!path.startsWith(pathPrefixWithSeparator)) {
            return Collections.emptySet();
        }
        String pathWithSlash = StringUtils.stripPrefix((String)path, (String)pathPrefixWithSeparator);
        if (!pathWithSlash.isEmpty()) {
            pathWithSlash = StringUtils.ensureEndsWith((String)pathWithSlash, (String)UniformPathUtils.SEPARATOR);
        }
        if ((names = (keys = index.getQueryNamesStartingWith(pathWithSlash)).stream().map(key -> pathPrefixWithSeparator + key).collect(Collectors.toSet())).isEmpty()) {
            if (path.equals(pathPrefixWithSeparator) || index.getQuery(StringUtils.stripSuffix((String)pathWithSlash, (String)UniformPathUtils.SEPARATOR)).isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(path);
        }
        return names;
    }

    private static String determineCorrectEntryName(String fullEntryName, String queryPath, boolean includeChildFullPath) {
        if (includeChildFullPath) {
            return fullEntryName;
        }
        return StoredQueryResourceResolutionStrategy.stripOffQueryPathAndSeparator(fullEntryName, queryPath);
    }

    private static boolean isEmptyOrContainsExactly(Set<String> names, String path) {
        return names.isEmpty() || names.size() == 1 && names.contains(path);
    }

    private static void appendContainerEntry(String name, List<String> childNames, String path, ContainerInfo container) {
        String fullPath = path + UniformPathUtils.SEPARATOR + name;
        if (childNames.size() == 1 && childNames.contains(fullPath)) {
            container.insertOrUpdateChildElementWithHash(fullPath, "1");
        } else {
            container.insertOrUpdateChildContainer(fullPath, StoredQueryResourceResolutionStrategy.determineCommonPrefix(childNames, fullPath + UniformPathUtils.SEPARATOR));
        }
    }

    private static String determineCommonPrefix(List<String> childNames, String commonPrefix) {
        Set reduced = childNames.stream().map(name -> StringUtils.stripPrefix((String)name, (String)commonPrefix)).collect(Collectors.toSet());
        while (reduced.size() > 1) {
            reduced = reduced.stream().map(UniformPathUtils::getParentPath).collect(Collectors.toSet());
        }
        return (String)CollectionUtils.getAny(reduced);
    }

    private static String extractRelativePlainName(String queryPath, String name) {
        return UniformPathUtils.extractProject((String)StoredQueryResourceResolutionStrategy.stripOffQueryPathAndSeparator(name, queryPath));
    }

    private static String stripOffQueryPathAndSeparator(String name, String queryPath) {
        String adjustedName = name;
        adjustedName = StringUtils.stripPrefix((String)adjustedName, (String)queryPath);
        return StringUtils.stripPrefix((String)adjustedName, (String)UniformPathUtils.SEPARATOR);
    }

    private StoredQueryIndex openIndex() throws StorageException {
        return StoredQueryIndex.openIndex(this.projectStorageSystem, this.storedQueryType);
    }

    private String getPathPrefix() {
        return this.storedQueryType.getUniformPathType().getPrefix();
    }

    private String getPathPrefixWithSeparator() {
        return this.getPathPrefix() + UniformPathUtils.SEPARATOR;
    }
}

