/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.teamscale.core.mail.MailSender;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.user.UserOptionIndex;
import com.teamscale.core.option.user.UserOptionRegistry;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskNotificationOption;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class TaskChangeNotifier {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Task task;
    private final User user;
    private final GlobalStorageSystem globalStorageSystem;
    private final UserOptionIndex userOptionIndex;
    private final UserIndex userIndex;

    public TaskChangeNotifier(Task task, User user, GlobalStorageSystem globalStorageSystem) throws StorageException {
        this.task = task;
        this.user = user;
        this.globalStorageSystem = globalStorageSystem;
        this.userOptionIndex = (UserOptionIndex)globalStorageSystem.openGlobalIndex(UserOptionIndex.class);
        this.userIndex = (UserIndex)globalStorageSystem.openGlobalIndex(UserIndex.class);
    }

    public void sendNotificationsToParticipants(String subject, String htmlMessage, TaskNotificationOption.ETaskNotificationEvent notificationEvent) throws StorageException {
        this.sendNotificationIfReceiverQualifies(this.task.getAssignee(), subject, htmlMessage, notificationEvent);
        this.sendNotificationIfReceiverQualifies(this.task.getAuthor(), subject, htmlMessage, notificationEvent);
    }

    private void sendNotificationIfReceiverQualifies(String receiver, String subject, String htmlMessage, TaskNotificationOption.ETaskNotificationEvent notificationEvent) throws StorageException {
        if (TaskChangeNotifier.doesQualifyAsReceiver(receiver, this.user)) {
            this.sendNotificationIfReceiverAllows(receiver, notificationEvent, subject, htmlMessage);
        }
    }

    private static boolean doesQualifyAsReceiver(String receiver, User user) {
        return receiver != null && !user.getUsername().equals(receiver);
    }

    private void sendNotificationIfReceiverAllows(String receiver, TaskNotificationOption.ETaskNotificationEvent notificationEvent, String subject, String htmlMessage) throws StorageException {
        TaskNotificationOption taskNotificationOption = TaskChangeNotifier.getTaskNotificationOption(receiver, this.userOptionIndex);
        if (taskNotificationOption.getTaskNotificationEvents().contains((Object)notificationEvent)) {
            this.sendNotification(receiver, subject, htmlMessage);
        }
    }

    private static TaskNotificationOption getTaskNotificationOption(String username, UserOptionIndex userOptionIndex) throws StorageException {
        UserOptionRegistry userOptionRegistry = UserOptionRegistry.getInstance();
        return (TaskNotificationOption)userOptionRegistry.getOption(username, "tasks.mail.notifications", null, TaskNotificationOption.class, (OptionIndexBase)userOptionIndex);
    }

    private void sendNotification(String usernameReceiver, String subject, String htmlMessage) {
        try {
            User user = this.userIndex.getUser(usernameReceiver);
            if (user == null) {
                this.logWarning("User could not be found.");
                return;
            }
            if (StringUtils.isEmpty((String)user.getEmailAddress())) {
                this.logWarning("No receiver email address was provided.");
                return;
            }
            MailSender mailSender = MailSender.createMailUtils((GlobalStorageSystem)this.globalStorageSystem);
            mailSender.sendHtmlMail(Collections.singletonList(user.getEmailAddress()), subject, htmlMessage, this.globalStorageSystem);
        }
        catch (MailSender.MailException | StorageException e) {
            LOGGER.error("Email sending failed: " + e.getMessage(), e);
        }
    }

    private void logWarning(String message) {
        LOGGER.warn("Email sending aborted: " + message);
    }
}

