/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;

public class ArchitecturePathDataRetriever
implements ITgaDataRetriever {
    private final UniformPath uniformPath;
    private final List<String> partitions;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final CrossAnnotator crossAnnotator;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public ArchitecturePathDataRetriever(UniformPath uniformPath, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.uniformPath = uniformPath;
        this.partitions = partitions;
        this.crossAnnotator = crossAnnotator;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        if (this.uniformPath.isArchitecturePath() && this.uniformPath.isRoot()) {
            return new UnassessedTestGapData(this.createDataForRootPathToArchitectures(methodInfoFilter));
        }
        Map<UniformPath, UniformPath> sourceToArchitecturePathMap = ArchitectureMetricsUtils.getRecursivePathMappings(this.dataRetrieverIndexes.getMetricsToArchitectureMetricsMappingIndex(), this.uniformPath);
        UnassessedTestGapData dataWithoutArchitecturePaths = this.fetchDataForUniformPaths(sourceToArchitecturePathMap.keySet(), methodInfoFilter);
        List<UnassessedTestGapData.UnassessedMethodData> methodsWithArchitecturePaths = ArchitecturePathDataRetriever.changeUniformPathBackToArchitecturePath(dataWithoutArchitecturePaths, sourceToArchitecturePathMap);
        return new UnassessedTestGapData(methodsWithArchitecturePaths);
    }

    private UnassessedTestGapData fetchDataForUniformPaths(Collection<UniformPath> uniformPaths, MethodInfoFilter methodInfoFilter) throws StorageException {
        List<AssociatedMethodInfo> methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(new ArrayList<UniformPath>(uniformPaths));
        return DataRetrieverUtils.createUnassessedTestGapData(methodInfos, this.partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
    }

    private List<UnassessedTestGapData.UnassessedMethodData> createDataForRootPathToArchitectures(MethodInfoFilter methodInfoFilter) throws StorageException {
        ContainerIndex containerIndex = this.dataRetrieverIndexes.getContainerIndex();
        ContainerInfo containerInfo = containerIndex.getContainer(ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES);
        if (containerInfo == null) {
            return CollectionUtils.emptyList();
        }
        Set<UniformPath> architectures = ArchitecturePathDataRetriever.getArchitectures(containerInfo, containerIndex);
        ArrayList<Map<UniformPath, UniformPath>> pathMappings = new ArrayList<Map<UniformPath, UniformPath>>();
        HashSet<UniformPath> sourcePaths = new HashSet<UniformPath>();
        for (UniformPath architecture : architectures) {
            Map<UniformPath, UniformPath> sourceToArchitecturePathMap = ArchitectureMetricsUtils.getRecursivePathMappings(this.dataRetrieverIndexes.getMetricsToArchitectureMetricsMappingIndex(), architecture);
            pathMappings.add(sourceToArchitecturePathMap);
            sourcePaths.addAll(sourceToArchitecturePathMap.keySet());
        }
        UnassessedTestGapData dataWithoutArchitecturePaths = this.fetchDataForUniformPaths(sourcePaths, methodInfoFilter);
        ArrayList<UnassessedTestGapData.UnassessedMethodData> methods = new ArrayList<UnassessedTestGapData.UnassessedMethodData>();
        for (Map map : pathMappings) {
            List<UnassessedTestGapData.UnassessedMethodData> translatedMethods = ArchitecturePathDataRetriever.changeUniformPathBackToArchitecturePath(dataWithoutArchitecturePaths, map);
            methods.addAll(translatedMethods);
        }
        return methods;
    }

    private static Set<UniformPath> getArchitectures(ContainerInfo containerInfo, ContainerIndex containerIndex) throws StorageException {
        HashSet<UniformPath> architectures = new HashSet<UniformPath>();
        Set<String> children = containerInfo.getChildren();
        for (String child : children) {
            if (UniformPathUtils.isArchitectureRootComponent((String)child)) {
                architectures.add(UniformPathCompatibilityUtil.convert((String)child));
                continue;
            }
            architectures.addAll(ArchitecturePathDataRetriever.getArchitectures(containerIndex.getContainer(child), containerIndex));
        }
        return architectures;
    }

    static List<UnassessedTestGapData.UnassessedMethodData> changeUniformPathBackToArchitecturePath(UnassessedTestGapData dataWithoutArchitecturePaths, @NonNull Map<UniformPath, UniformPath> sourceToArchitecturePathMap) {
        ArrayList<UnassessedTestGapData.UnassessedMethodData> translatedMethods = new ArrayList<UnassessedTestGapData.UnassessedMethodData>();
        for (UnassessedTestGapData.UnassessedMethodData method : dataWithoutArchitecturePaths.getMethods()) {
            UniformPath architecturePath = sourceToArchitecturePathMap.get(method.getLocation().getUniformPath());
            if (architecturePath == null) continue;
            translatedMethods.add(method.withUniformPath(architecturePath));
        }
        return translatedMethods;
    }
}

