/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.upload.sonarqube.data;

import com.teamscale.index.findings.IntegratedToolUpdateUtils;
import com.teamscale.index.report.parser.sonarqube.SonarqubeIssueData;
import com.teamscale.index.report.parser.sonarqube.SonarqubeRuleDetails;
import com.teamscale.index.upload.IExternalToolRule;
import eu.cqse.check.framework.core.EFindingEnablement;
import org.apache.commons.text.WordUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jspecify.annotations.Nullable;

public class SonarqubeRule
implements IExternalToolRule {
    private final String id;
    private final String sonarqubeID;
    private final String shortDescription;
    private final String fullDescription;
    private final String type;
    private final String defaultSeverity;
    private final String softwareQuality;

    public SonarqubeRule(SonarqubeIssueData data, @Nullable SonarqubeRuleDetails ruleDetails) {
        this.type = data.type();
        this.defaultSeverity = data.severity();
        this.id = "SonarQube:" + data.rule();
        this.sonarqubeID = data.rule();
        this.softwareQuality = SonarqubeRule.extractSoftwareQuality(data);
        if (ruleDetails != null) {
            this.shortDescription = ruleDetails.name() != null ? ruleDetails.name() : data.message();
            this.fullDescription = SonarqubeRule.buildFullDescription(ruleDetails);
        } else {
            this.shortDescription = data.message();
            this.fullDescription = null;
        }
    }

    private static String extractSoftwareQuality(SonarqubeIssueData data) {
        return data.impacts().getFirst().softwareQuality();
    }

    private static String buildFullDescription(SonarqubeRuleDetails ruleDetails) {
        if (ruleDetails.descriptionSections() == null || ruleDetails.descriptionSections().isEmpty()) {
            return null;
        }
        StringBuilder description = new StringBuilder();
        SonarqubeRuleDetails.DescriptionSection resourcesSection = SonarqubeRule.processSections(ruleDetails, description);
        if (resourcesSection != null) {
            String header = SonarqubeRule.formatSectionHeader(resourcesSection.key());
            description.append("# ").append(header).append("\n\n");
            description.append(SonarqubeRule.convertHtmlPreTagsToMarkdownCodeFences(resourcesSection.content())).append("\n\n");
        }
        return !description.isEmpty() ? description.toString().strip() : null;
    }

    private static @Nullable SonarqubeRuleDetails.DescriptionSection processSections(SonarqubeRuleDetails ruleDetails, StringBuilder description) {
        SonarqubeRuleDetails.DescriptionSection resourcesSection = null;
        for (SonarqubeRuleDetails.DescriptionSection section : ruleDetails.descriptionSections()) {
            SonarqubeRuleDetails.DescriptionSection unProcessedSection;
            if (section.content() == null || section.content().isEmpty() || (unProcessedSection = SonarqubeRule.processSection(section, description)) == null) continue;
            resourcesSection = unProcessedSection;
        }
        return resourcesSection;
    }

    private static SonarqubeRuleDetails.DescriptionSection processSection(SonarqubeRuleDetails.DescriptionSection section, StringBuilder description) {
        if ("resources".equals(section.key())) {
            return section;
        }
        if (section.key() != null) {
            String header = SonarqubeRule.formatSectionHeader(section.key());
            description.append("# ").append(header).append("\n\n");
        }
        description.append(SonarqubeRule.convertHtmlPreTagsToMarkdownCodeFences(section.content())).append("\n\n");
        return null;
    }

    private static String convertHtmlPreTagsToMarkdownCodeFences(String htmlContent) {
        Document doc = Jsoup.parse((String)htmlContent);
        doc.outputSettings().prettyPrint(false);
        for (Element preElement : doc.select("pre")) {
            String codeContent = preElement.wholeText();
            String markdownCodeBlock = "\n```\n" + codeContent + "\n```\n";
            preElement.replaceWith((Node)new TextNode(markdownCodeBlock));
        }
        return doc.body().html();
    }

    private static String formatSectionHeader(String key) {
        return WordUtils.capitalizeFully((String)key.replace("_", " "));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getSonarqubeID() {
        return this.sonarqubeID;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public String getReadableName() {
        return IntegratedToolUpdateUtils.makeMarkdownUnambiguous(this.getShortDescription());
    }

    @Override
    public @Nullable String getFullDescription() {
        return this.fullDescription;
    }

    @Override
    public EFindingEnablement getFindingEnablement() {
        String severity;
        if (this.defaultSeverity != null && ("blocker".equals(severity = this.defaultSeverity.toLowerCase()) || "critical".equals(severity))) {
            return EFindingEnablement.RED;
        }
        return EFindingEnablement.YELLOW;
    }

    @Override
    public String getAnalysisGroup() {
        String analysisGroup = this.type.replace("_", " ");
        return WordUtils.capitalizeFully((String)analysisGroup);
    }

    @Override
    public String getQualityIndicator() {
        return WordUtils.capitalizeFully((String)this.softwareQuality);
    }
}

