/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.license.License;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.log.service.GlobalServiceLogIndex;
import com.teamscale.core.log.service.ProjectServiceLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.InstanceIdOption;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.VersionUtil;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.repository.sap.abapsystem.SapVersionIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.ProcessArtifactIndexes;
import com.teamscale.index.system_info.JavaSystemInfoFragment;
import com.teamscale.index.system_info.OperatingSystemInfoFragment;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemInfoIndex;
import com.teamscale.index.tests.TestExecutionIndexes;
import com.teamscale.index.usage_data.ErrorStatistics;
import com.teamscale.index.usage_data.FeatureUsageCounts;
import com.teamscale.index.usage_data.InstanceInformationCollectionUtils;
import com.teamscale.index.usage_data.ProjectConfigurationOverview;
import com.teamscale.index.usage_data.SapVersionCounts;
import com.teamscale.index.usage_data.SystemInformation;
import com.teamscale.index.usage_data.UsageData;
import com.teamscale.index.usage_data.UsageDataReportingOption;
import com.teamscale.index.usage_data.UserAgentsIndex;
import com.teamscale.index.usage_data.UserCounts;
import eu.cqse.check.framework.scanner.ELanguage;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.RunnableWithException;

public class UsageDataCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IndexLayer indexLayer;
    private final ServerOptionIndex optionIndex;
    private final GlobalStorageSystem globalStorageSystem;
    private PairList<ProjectInfo, ProjectStorageSystem> projectsAndStorageSystemsCache;

    public UsageDataCollector(IndexLayer indexLayer) throws StorageException {
        this.indexLayer = indexLayer;
        this.globalStorageSystem = indexLayer.openGlobalStorageSystem();
        this.optionIndex = (ServerOptionIndex)this.globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
    }

    public static int calculateActiveUsers(TemporalAmount duration, List<Long> lastActivityTimestamps) {
        long threshold = DateTimeUtils.zonedNow().minus(duration).toInstant().toEpochMilli();
        return (int)lastActivityTimestamps.stream().mapToLong(Long::longValue).filter(x -> x > threshold).count();
    }

    public String collect(UsageDataReportingOption option) throws StorageException {
        String instanceId = InstanceIdOption.getId((ServerOptionIndex)this.optionIndex);
        CCSMAssert.isNotNull((Object)instanceId);
        License license = LicenseManager.getInstance().getLicense();
        String licenseId = null;
        if (license != null) {
            licenseId = license.getSignatureString();
        }
        String version = VersionUtil.readTeamscaleVersionDetails();
        UsageData usageInfo = new UsageData(instanceId, licenseId, version);
        this.addDetailsIfConfigured(usageInfo, option);
        return InstanceInformationCollectionUtils.insertCheckSum(JsonUtils.serializeToJSON((Object)usageInfo));
    }

    private void addDetailsIfConfigured(UsageData usageInfo, UsageDataReportingOption option) {
        UsageDataCollector.addOptionalData(option.includeUsers, "user count info", (RunnableWithException<StorageException>)((RunnableWithException)() -> {
            usageInfo.setUsers(this.collectUserCountInfo());
            usageInfo.setDevelopers(this.getCommitterCountInfo());
        }));
        UsageDataCollector.addOptionalData(option.includeSystem, "system information", (RunnableWithException<StorageException>)((RunnableWithException)() -> usageInfo.setSystemInformation(this.collectSystemInformation())));
        UsageDataCollector.addOptionalData(option.includeUserAgents, "user agent information", (RunnableWithException<StorageException>)((RunnableWithException)() -> usageInfo.setUserAgentInformation(this.collectUserAgentInformation())));
        UsageDataCollector.addOptionalData(option.includeSapVersions, "SAP version information", (RunnableWithException<StorageException>)((RunnableWithException)() -> usageInfo.setSapVersions(this.collectSapVersions())));
        UsageDataCollector.addOptionalData(option.includeProjects, "project configuration info", (RunnableWithException<StorageException>)((RunnableWithException)() -> usageInfo.setProjects(this.collectProjectConfigurationInfo())));
        UsageDataCollector.addOptionalData(option.includeFeatures, "feature usage info", (RunnableWithException<StorageException>)((RunnableWithException)() -> usageInfo.setFeatures(this.collectFeatureUsageInfo())));
        UsageDataCollector.addOptionalData(option.includeErrors, "error info", (RunnableWithException<StorageException>)((RunnableWithException)() -> usageInfo.setErrors(this.collectErrorInfo())));
    }

    private static void addOptionalData(boolean include, String description, RunnableWithException<StorageException> dataAddRunnable) {
        if (!include) {
            return;
        }
        try {
            dataAddRunnable.run();
        }
        catch (StorageException e) {
            LOGGER.error("Could not collect {}! Skipping this part.", (Object)description, (Object)e);
        }
    }

    private UserCounts collectUserCountInfo() throws StorageException {
        UserLastActivityIndex lastActivityIndex = (UserLastActivityIndex)this.globalStorageSystem.openGlobalIndex(UserLastActivityIndex.class);
        List lastActivityTimestamps = lastActivityIndex.getLastActivityTimestamps();
        int lastDay = UsageDataCollector.calculateActiveUsers(EUserActivityPeriods.LAST_DAY.getAmount(), lastActivityTimestamps);
        int lastWeek = UsageDataCollector.calculateActiveUsers(EUserActivityPeriods.LAST_WEEK.getAmount(), lastActivityTimestamps);
        int lastMonth = UsageDataCollector.calculateActiveUsers(EUserActivityPeriods.LAST_MONTH.getAmount(), lastActivityTimestamps);
        int lastQuarter = UsageDataCollector.calculateActiveUsers(EUserActivityPeriods.LAST_90DAYS.getAmount(), lastActivityTimestamps);
        int last180Days = UsageDataCollector.calculateActiveUsers(EUserActivityPeriods.LAST_180DAYS.getAmount(), lastActivityTimestamps);
        int lastYear = UsageDataCollector.calculateActiveUsers(EUserActivityPeriods.LAST_YEAR.getAmount(), lastActivityTimestamps);
        return new UserCounts(lastDay, lastWeek, lastMonth, lastQuarter, last180Days, lastYear);
    }

    private UserCounts getCommitterCountInfo() throws StorageException {
        UserLastActivityIndex index = (UserLastActivityIndex)this.indexLayer.openGlobalIndex(UserLastActivityIndex.class);
        return new UserCounts(index.getNumberOfCommitters(EUserActivityPeriods.LAST_DAY), index.getNumberOfCommitters(EUserActivityPeriods.LAST_WEEK), index.getNumberOfCommitters(EUserActivityPeriods.LAST_MONTH), index.getNumberOfCommitters(EUserActivityPeriods.LAST_90DAYS), index.getNumberOfCommitters(EUserActivityPeriods.LAST_180DAYS), index.getNumberOfCommitters(EUserActivityPeriods.LAST_YEAR));
    }

    private SystemInformation collectSystemInformation() throws StorageException {
        String javaVersion = "unknown";
        String operatingSystem = "unknown";
        SystemInfoIndex index = (SystemInfoIndex)this.globalStorageSystem.openGlobalIndex(SystemInfoIndex.class);
        for (SystemInfoFragmentBase fragment : index.getAllValidFragments()) {
            if (fragment instanceof JavaSystemInfoFragment) {
                JavaSystemInfoFragment javaFragment = (JavaSystemInfoFragment)fragment;
                javaVersion = javaFragment.getJvmNameAndVersion();
                continue;
            }
            if (!(fragment instanceof OperatingSystemInfoFragment)) continue;
            OperatingSystemInfoFragment osFragment = (OperatingSystemInfoFragment)fragment;
            operatingSystem = osFragment.getDescription();
        }
        return new SystemInformation(javaVersion, operatingSystem);
    }

    private Map<String, Integer> collectUserAgentInformation() throws StorageException {
        UserAgentsIndex userAgentsIndex = (UserAgentsIndex)this.globalStorageSystem.openGlobalIndex(UserAgentsIndex.class);
        return userAgentsIndex.getUserAgentFrequency().toMap();
    }

    private SapVersionCounts collectSapVersions() throws StorageException {
        SapVersionIndex sapVersionIndex = (SapVersionIndex)this.globalStorageSystem.openGlobalIndex(SapVersionIndex.class);
        CounterSet<String> abapVersionFrequency = sapVersionIndex.getAbapVersionFrequency();
        CounterSet<String> connectorVersionFrequency = sapVersionIndex.getConnectorVersionFrequency();
        return new SapVersionCounts(abapVersionFrequency, connectorVersionFrequency);
    }

    private ProjectConfigurationOverview collectProjectConfigurationInfo() throws StorageException {
        ProjectConfigurationOverview projectConfigurationInfo = new ProjectConfigurationOverview(this.listProjectsAndStorageSystems().size());
        HashSet usedAnalysisProfiles = new HashSet();
        this.listProjectsAndStorageSystems().forEach((projectInfo, storageSystem) -> UsageDataCollector.extractFromProjectConfiguration(projectInfo, storageSystem, projectConfigurationInfo, usedAnalysisProfiles));
        for (AnalysisProfile analysisProfile : ((AnalysisProfileIndex)this.globalStorageSystem.openGlobalIndex(AnalysisProfileIndex.class)).getProfiles(new ArrayList(usedAnalysisProfiles), false)) {
            if (analysisProfile == null) continue;
            projectConfigurationInfo.getLanguages().addAll((Collection<ELanguage>)analysisProfile.getLanguages());
        }
        return projectConfigurationInfo;
    }

    private static void extractFromProjectConfiguration(ProjectInfo projectInfo, ProjectStorageSystem projectStorageSystem, ProjectConfigurationOverview projectConfigurationInfo, Set<String> usedAnalysisProfiles) {
        ProjectConfiguration projectConfiguration;
        try {
            projectConfiguration = (ProjectConfiguration)((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getValue(ProjectConfiguration.class);
        }
        catch (StorageException e) {
            LOGGER.error("Could not determine project configuration of {}. Skipping.", (Object)projectInfo.getInternalId(), (Object)e);
            return;
        }
        usedAnalysisProfiles.addAll(projectConfiguration.getAnalysisProfileNames());
        for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
            for (ERepositoryConnector eRepositoryConnector : ERepositoryConnector.values()) {
                if (!connectorConfiguration.isRepositoryType(eRepositoryConnector)) continue;
                projectConfigurationInfo.getRepositories().add(eRepositoryConnector);
            }
            for (ERepositoryConnector eRepositoryConnector : EIssueTracker.values()) {
                if (!connectorConfiguration.isIssueTrackerType((EIssueTracker)eRepositoryConnector)) continue;
                projectConfigurationInfo.getIssueTrackers().add((EIssueTracker)eRepositoryConnector);
            }
        }
    }

    private FeatureUsageCounts collectFeatureUsageInfo() throws StorageException {
        int architectures = 0;
        int issueQueries = 0;
        int projectsWithNonCodeMetrics = 0;
        int projectsWithTestResults = 0;
        int projectsWithTestCoverage = 0;
        PairList<ProjectInfo, ProjectStorageSystem> projectsAndSystems = this.listProjectsAndStorageSystems();
        for (int i = 0; i < projectsAndSystems.size(); ++i) {
            ProjectStorageSystem storageSystem = (ProjectStorageSystem)projectsAndSystems.getSecond(i);
            try {
                String branchName = UsageDataCollector.getDefaultBranchName(storageSystem);
                issueQueries += UsageDataCollector.getIssueQueryCount(storageSystem);
                architectures += UsageDataCollector.getArchitectureCount(storageSystem, branchName);
                if (UsageDataCollector.hasNonCodeMetrics(storageSystem, branchName)) {
                    ++projectsWithNonCodeMetrics;
                }
                if (UsageDataCollector.hasTestResults(storageSystem, branchName)) {
                    ++projectsWithTestResults;
                }
                if (!UsageDataCollector.hasTestCoverage(storageSystem)) continue;
                ++projectsWithTestCoverage;
                continue;
            }
            catch (StorageException e) {
                LOGGER.error("Failed to extract project information for project {}! Skipping.", (Object)((ProjectInfo)projectsAndSystems.getFirst(i)).getInternalId(), (Object)e);
            }
        }
        return new FeatureUsageCounts(architectures, issueQueries, projectsWithNonCodeMetrics, projectsWithTestResults, projectsWithTestCoverage);
    }

    private static int getArchitectureCount(ProjectStorageSystem storageSystem, String branchName) throws StorageException {
        return ((ArchitectureAssessmentIndex)storageSystem.openProjectIndex(ArchitectureAssessmentIndex.class, HistoryAccessOption.readHead((String)branchName))).getAllAssessmentUniformPaths().size();
    }

    private static int getIssueQueryCount(ProjectStorageSystem storageSystem) throws StorageException {
        return StoredQueryIndex.openIndex(storageSystem, StoredQueryIndex.EStoredQueryType.ISSUE).getAllQueryNames().size();
    }

    private static String getDefaultBranchName(ProjectStorageSystem storageSystem) throws StorageException {
        return ((MetaIndex)storageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
    }

    private static boolean hasNonCodeMetrics(ProjectStorageSystem projectStorageSystem, String branchName) throws StorageException {
        return UsageDataCollector.containerIndexNotEmpty((ContainerIndex)projectStorageSystem.openProjectIndex(ProcessArtifactIndexes.PROCESS_ARTIFACT_DIRECTORY_INDEX_TYPE, "process-dir", HistoryAccessOption.readHead((String)branchName)));
    }

    private static boolean hasTestResults(ProjectStorageSystem projectStorageSystem, String branchName) throws StorageException {
        return UsageDataCollector.containerIndexNotEmpty((ContainerIndex)projectStorageSystem.openProjectIndex(TestExecutionIndexes.TEST_EXECUTION_DIRECTORY_INDEX_TYPE, "test-execution-dir", HistoryAccessOption.readHead((String)branchName)));
    }

    private static boolean containerIndexNotEmpty(ContainerIndex index) throws StorageException {
        ContainerInfo rootValue = index.getContainer("");
        return rootValue != null && !rootValue.getChildren().isEmpty();
    }

    private static boolean hasTestCoverage(ProjectStorageSystem projectStorageSystem) throws StorageException {
        ExternalAnalysisPartitionIndex index = (ExternalAnalysisPartitionIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisPartitionIndex.class, null);
        return !index.getCoveragePartitions().isEmpty();
    }

    private ErrorStatistics collectErrorInfo() throws StorageException {
        int[] globalWorkerLogFrequencies = ((GlobalWorkerLogIndex)this.globalStorageSystem.openGlobalIndex(GlobalWorkerLogIndex.class)).getLogLevelFrequencies();
        int workerLogErrors = globalWorkerLogFrequencies[LogIndexBase.EIndexLogLevel.ERROR.ordinal()];
        int workerLogWarnings = globalWorkerLogFrequencies[LogIndexBase.EIndexLogLevel.WARN.ordinal()];
        int[] globalServiceLogFrequencies = ((GlobalServiceLogIndex)this.globalStorageSystem.openGlobalIndex(GlobalServiceLogIndex.class)).getLogLevelFrequencies();
        int serviceLogErrors = globalServiceLogFrequencies[LogIndexBase.EIndexLogLevel.ERROR.ordinal()];
        int serviceLogWarnings = globalServiceLogFrequencies[LogIndexBase.EIndexLogLevel.WARN.ordinal()];
        int parseLogWarnings = 0;
        PairList<ProjectInfo, ProjectStorageSystem> projectsAndSystems = this.listProjectsAndStorageSystems();
        for (int i = 0; i < projectsAndSystems.size(); ++i) {
            ProjectStorageSystem storageSystem = (ProjectStorageSystem)projectsAndSystems.getSecond(i);
            try {
                int[] projectWorkerLogFrequencies = ((ProjectWorkerLogIndex)storageSystem.openProjectIndex(ProjectWorkerLogIndex.class, null)).getLogLevelFrequencies();
                workerLogErrors += projectWorkerLogFrequencies[LogIndexBase.EIndexLogLevel.ERROR.ordinal()];
                workerLogWarnings += projectWorkerLogFrequencies[LogIndexBase.EIndexLogLevel.WARN.ordinal()];
                int[] projectServiceLogFrequencies = ((ProjectServiceLogIndex)storageSystem.openProjectIndex(ProjectServiceLogIndex.class, null)).getLogLevelFrequencies();
                serviceLogErrors += projectServiceLogFrequencies[LogIndexBase.EIndexLogLevel.ERROR.ordinal()];
                serviceLogWarnings += projectServiceLogFrequencies[LogIndexBase.EIndexLogLevel.WARN.ordinal()];
                parseLogWarnings += ((ParseLogIndex)storageSystem.openProjectIndex(ParseLogIndex.class, null)).getNumberOfEntries();
                continue;
            }
            catch (StorageException e) {
                LOGGER.error("Failed to extract project information for project {}! Skipping.", (Object)((ProjectInfo)projectsAndSystems.getFirst(i)).getInternalId(), (Object)e);
            }
        }
        return new ErrorStatistics(workerLogErrors, workerLogWarnings, serviceLogErrors, serviceLogWarnings, parseLogWarnings);
    }

    private PairList<ProjectInfo, ProjectStorageSystem> listProjectsAndStorageSystems() throws StorageException {
        return this.listProjectsAndStorageSystems((Set<String>)CollectionUtils.emptySet());
    }

    private PairList<ProjectInfo, ProjectStorageSystem> listProjectsAndStorageSystems(Set<String> projectIdsToInclude) throws StorageException {
        if (this.projectsAndStorageSystemsCache == null) {
            this.projectsAndStorageSystemsCache = new PairList();
            for (ProjectInfo projectInfo : ((ProjectIndex)this.globalStorageSystem.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos()) {
                if (projectInfo.isDeletingOrReanalyzing()) continue;
                this.projectsAndStorageSystemsCache.add((Object)projectInfo, (Object)this.indexLayer.openProjectStorageSystem(projectInfo));
            }
        }
        if (projectIdsToInclude.isEmpty()) {
            return this.projectsAndStorageSystemsCache;
        }
        return (PairList)this.projectsAndStorageSystemsCache.stream().filter(projectAndStorage -> projectIdsToInclude.contains(((ProjectInfo)projectAndStorage.getFirst()).getPrimaryPublicId().toString())).collect(PairList.toPairList());
    }
}

