/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2278")
public class AvoidDESCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Use the recommended AES (Advanced Encryption Standard) instead.";
    private static final Set<String> MCRYPT_CIPHERS = Set.of("MCRYPT_3DES", "MCRYPT_DES", "MCRYPT_DES_COMPAT", "MCRYPT_TRIPLEDES");
    private static final String OPENSSL_DES = "des-ede3";

    @Override
    public void visitNameIdentifier(NameIdentifierTree tree) {
        if (MCRYPT_CIPHERS.contains(tree.text())) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitNameIdentifier(tree);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        String literal = CheckUtils.trimQuotes(tree.value().toLowerCase(Locale.ROOT));
        if (literal.startsWith(OPENSSL_DES)) {
            this.context().newIssue(this, tree, MESSAGE);
        }
        super.visitLiteral(tree);
    }
}

