/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S1603")
public class ConstructorDeclarationCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1603";
    private static final String MESSAGE_OLD_STYLE_PRESENT = "Replace this function name \"%s\" with \"__construct\".";
    private static final String MESSAGE_BOTH_STYLE_PRESENT = "Replace this function name \"%s\", since a \"__construct\" method has already been defined in this class.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS_DECLARATION);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassDeclarationTree classDec = (ClassDeclarationTree)tree;
        MethodDeclarationTree oldStyleConstructor = null;
        MethodDeclarationTree newStyleConstructor = null;
        boolean namespaceContext = this.isClassInNamespaceContext(classDec);
        for (ClassMemberTree member : classDec.members()) {
            if (!member.is(Tree.Kind.METHOD_DECLARATION)) continue;
            MethodDeclarationTree method = (MethodDeclarationTree)member;
            String methodName = method.name().text();
            if (classDec.name().text().equalsIgnoreCase(methodName) && !namespaceContext) {
                oldStyleConstructor = method;
                continue;
            }
            if (!"__construct".equalsIgnoreCase(methodName)) continue;
            newStyleConstructor = method;
        }
        if (oldStyleConstructor != null) {
            String message = String.format(newStyleConstructor != null ? MESSAGE_BOTH_STYLE_PRESENT : MESSAGE_OLD_STYLE_PRESENT, oldStyleConstructor.name().text());
            this.context().newIssue(this, oldStyleConstructor.name(), message);
        }
    }

    private boolean isClassInNamespaceContext(ClassDeclarationTree classDec) {
        Symbol symbol = this.context().symbolTable().getSymbol(classDec.name());
        QualifiedName qualifiedName = symbol.qualifiedName();
        return qualifiedName != null && !qualifiedName.toString().equals(symbol.name());
    }
}

