/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.phpini.PhpIniBoolean;
import org.sonar.php.checks.phpini.PhpIniFiles;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.ini.PhpIniCheck;
import org.sonar.php.ini.PhpIniIssue;
import org.sonar.php.ini.tree.PhpIniFile;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2092")
public class CookiesSecureCheck
extends PHPVisitorCheck
implements PhpIniCheck {
    private static final String MESSAGE_PHP_INI = "Make sure creating the session cookie without the \"secure\" flag is safe here.";
    private static final String MESSAGE = "Make sure creating this cookie without the \"secure\" flag is safe here.";
    private static final List<String> SET_COOKIE_FUNCTIONS = Arrays.asList("setcookie", "setrawcookie");
    private static final int SET_COOKIE_SECURE_PARAMETER = 5;
    private static final String SESSION_COOKIE_FUNC = "session_set_cookie_params";
    private static final int SESSION_COOKIE_SECURE_PARAMETER = 3;

    @Override
    public List<PhpIniIssue> analyze(PhpIniFile phpIniFile) {
        return PhpIniFiles.checkRequiredBoolean(phpIniFile, "session.cookie_secure", PhpIniBoolean.ON, MESSAGE_PHP_INI, MESSAGE_PHP_INI);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        Optional<CallArgumentTree> secureArgument;
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (SET_COOKIE_FUNCTIONS.contains(functionName)) {
            secureArgument = CheckUtils.argument(tree, "secure", 5);
            this.checkForIssues(tree, secureArgument.orElse(null));
        }
        if (SESSION_COOKIE_FUNC.equals(functionName)) {
            secureArgument = CheckUtils.argument(tree, "secure", 3);
            this.checkForIssues(tree, secureArgument.orElse(null));
        }
        super.visitFunctionCall(tree);
    }

    private void checkForIssues(FunctionCallTree tree, @Nullable CallArgumentTree secureArgument) {
        if (secureArgument != null) {
            this.raiseIssueIfBadFlag(tree, secureArgument.value());
        } else {
            this.raiseIssueIfArgumentIsNotDefined(tree);
        }
    }

    private void raiseIssueIfArgumentIsNotDefined(FunctionCallTree tree) {
        if (tree.callArguments().size() == 3) {
            return;
        }
        this.context().newIssue(this, tree.callee(), MESSAGE);
    }

    private void raiseIssueIfBadFlag(FunctionCallTree tree, ExpressionTree secureArgument) {
        if (CheckUtils.isFalseValue(secureArgument)) {
            this.context().newIssue(this, tree.callee(), MESSAGE).secondary(secureArgument, null);
        }
    }
}

