/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.cache.CpdDeserializationInput;
import org.sonar.php.cache.CpdDeserializer;
import org.sonar.php.cache.CpdSerializationInput;
import org.sonar.php.cache.CpdSerializer;
import org.sonar.php.cache.SerializationResult;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.cache.PhpReadCache;
import org.sonar.plugins.php.api.cache.PhpWriteCache;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.InlineHTMLTree;
import org.sonar.plugins.php.api.tree.statement.UseStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;
import org.sonar.plugins.php.api.visitors.PhpInputFileContext;

public class CpdVisitor
extends PHPVisitorCheck {
    public static final String CACHE_DATA_PREFIX = "php.cpd.data:";
    public static final String CACHE_STRING_TABLE_PREFIX = "php.cpd.stringTable:";
    private List<CpdToken> cpdTokens = new ArrayList<CpdToken>();
    private static final String NORMALIZED_NUMERIC_LITERAL = "$NUMBER";
    private static final String NORMALIZED_CHARACTER_LITERAL = "$CHARS";

    @Override
    public void visitScript(ScriptTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitInlineHTML(InlineHTMLTree tree) {
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            this.addToken(tree.token(), NORMALIZED_NUMERIC_LITERAL);
        } else if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.NOWDOC_LITERAL)) {
            this.addToken(tree.token(), NORMALIZED_CHARACTER_LITERAL);
        } else {
            super.visitLiteral(tree);
        }
    }

    @Override
    public void visitExpandableStringCharacters(ExpandableStringCharactersTree tree) {
        this.addToken(tree.token(), NORMALIZED_CHARACTER_LITERAL);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (((InternalSyntaxToken)token).isEOF()) {
            return;
        }
        this.addToken(token, token.text());
    }

    private void addToken(SyntaxToken token, String text) {
        this.cpdTokens.add(CpdToken.create(token, text));
    }

    @Override
    public void visitUseStatement(UseStatementTree tree) {
    }

    @Override
    public void visitAttributeGroup(AttributeGroupTree tree) {
    }

    public List<CpdToken> computeCpdTokens(PhpFile file, CompilationUnitTree tree, SymbolTable symbolTable, @Nullable CacheContext cacheContext) {
        super.analyze(file, tree, symbolTable);
        this.storeCpdTokensInCache(file, cacheContext);
        return this.cpdTokens;
    }

    public List<CpdToken> getCpdTokens() {
        return this.cpdTokens;
    }

    @Override
    public boolean scanWithoutParsing(PhpInputFileContext phpInputFileContext) {
        List<CpdToken> restoredTokens = CpdVisitor.restoreCpdTokensFromCache(phpInputFileContext);
        if (restoredTokens != null) {
            this.cpdTokens = restoredTokens;
            return true;
        }
        return false;
    }

    private void storeCpdTokensInCache(PhpFile file, @Nullable CacheContext cacheContext) {
        PhpWriteCache writeCache;
        if (cacheContext != null && cacheContext.isCacheEnabled() && (writeCache = cacheContext.getWriteCache()) != null) {
            CpdSerializationInput input = new CpdSerializationInput(this.cpdTokens, cacheContext.pluginVersion());
            SerializationResult serializationResult = CpdSerializer.toBinary(input);
            String dataKey = CACHE_DATA_PREFIX + file.key();
            writeCache.writeBytes(dataKey, serializationResult.data());
            String stringTableKey = CACHE_STRING_TABLE_PREFIX + file.key();
            writeCache.writeBytes(stringTableKey, serializationResult.stringTable());
        }
    }

    @CheckForNull
    private static List<CpdToken> restoreCpdTokensFromCache(PhpInputFileContext phpInputFileContext) {
        PhpReadCache readCache;
        CacheContext cacheContext = phpInputFileContext.cacheContext();
        if (cacheContext != null && (readCache = cacheContext.getReadCache()) != null) {
            byte[] dataBytes = readCache.readBytes(CACHE_DATA_PREFIX + phpInputFileContext.phpFile().key());
            byte[] stringTableBytes = readCache.readBytes(CACHE_STRING_TABLE_PREFIX + phpInputFileContext.phpFile().key());
            if (dataBytes != null && stringTableBytes != null) {
                CpdDeserializationInput input = new CpdDeserializationInput(dataBytes, stringTableBytes, cacheContext.pluginVersion());
                return CpdDeserializer.fromBinary(input);
            }
        }
        return null;
    }

    public static class CpdToken {
        private final int line;
        private final int column;
        private final int endLine;
        private final int endColumn;
        private final String text;

        public CpdToken(int line, int column, int endLine, int endColumn, String text) {
            this.line = line;
            this.column = column;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.text = text;
        }

        public static CpdToken create(SyntaxToken token, String text) {
            return new CpdToken(token.line(), token.column(), token.endLine(), token.endColumn(), text);
        }

        public int line() {
            return this.line;
        }

        public int column() {
            return this.column;
        }

        public int endLine() {
            return this.endLine;
        }

        public int endColumn() {
            return this.endColumn;
        }

        public String text() {
            return this.text;
        }
    }
}

