/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.OptimisticTransactionOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionalDB;
import org.rocksdb.WriteOptions;

public class OptimisticTransactionDB
extends RocksDB
implements TransactionalDB<OptimisticTransactionOptions> {
    private OptimisticTransactionDB(long nativeHandle) {
        super(nativeHandle);
    }

    public static OptimisticTransactionDB open(Options options, String path) throws RocksDBException {
        OptimisticTransactionDB otdb = new OptimisticTransactionDB(OptimisticTransactionDB.open(options.nativeHandle_, path));
        otdb.storeOptionsInstance(options);
        return otdb;
    }

    public static OptimisticTransactionDB open(DBOptions dbOptions, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        long[] cfOptionHandles = new long[columnFamilyDescriptors.size()];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor cfDescriptor = columnFamilyDescriptors.get(i);
            cfNames[i] = cfDescriptor.getName();
            cfOptionHandles[i] = cfDescriptor.getOptions().nativeHandle_;
        }
        long[] handles = OptimisticTransactionDB.open(dbOptions.nativeHandle_, path, cfNames, cfOptionHandles);
        OptimisticTransactionDB otdb = new OptimisticTransactionDB(handles[0]);
        otdb.storeOptionsInstance(dbOptions);
        for (int i = 1; i < handles.length; ++i) {
            columnFamilyHandles.add(new ColumnFamilyHandle(otdb, handles[i]));
        }
        return otdb;
    }

    @Override
    public void closeE() throws RocksDBException {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                OptimisticTransactionDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                OptimisticTransactionDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, OptimisticTransactionOptions optimisticTransactionOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_, optimisticTransactionOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, Transaction oldTransaction) {
        long jtxn_handle = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, oldTransaction.nativeHandle_);
        assert (jtxn_handle == oldTransaction.nativeHandle_);
        return oldTransaction;
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, OptimisticTransactionOptions optimisticTransactionOptions, Transaction oldTransaction) {
        long jtxn_handle = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, optimisticTransactionOptions.nativeHandle_, oldTransaction.nativeHandle_);
        assert (jtxn_handle == oldTransaction.nativeHandle_);
        return oldTransaction;
    }

    public RocksDB getBaseDB() {
        RocksDB db = new RocksDB(this.getBaseDB(this.nativeHandle_));
        db.disOwnNativeHandle();
        return db;
    }

    @Override
    protected final native void disposeInternal(long var1);

    protected static native long open(long var0, String var2) throws RocksDBException;

    protected static native long[] open(long var0, String var2, byte[][] var3, long[] var4);

    private static native void closeDatabase(long var0) throws RocksDBException;

    private native long beginTransaction(long var1, long var3);

    private native long beginTransaction(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5, long var7);

    private native long getBaseDB(long var1);
}

