/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.location;

import com.microsoft.tfs.core.ServerCapabilities;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.location.AccessMapping;
import com.microsoft.tfs.core.clients.framework.location.ConnectOptions;
import com.microsoft.tfs.core.clients.framework.location.ConnectionData;
import com.microsoft.tfs.core.clients.framework.location.LocationMapping;
import com.microsoft.tfs.core.clients.framework.location.LocationServiceData;
import com.microsoft.tfs.core.clients.framework.location.RelativeToSetting;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.core.clients.framework.location.exceptions.AccessPointIsMalformedURLException;
import com.microsoft.tfs.core.clients.framework.location.exceptions.InvalidAccessPointException;
import com.microsoft.tfs.core.clients.framework.location.exceptions.InvalidServiceDefinitionException;
import com.microsoft.tfs.core.clients.framework.location.exceptions.LocationMethodNotImplementedException;
import com.microsoft.tfs.core.clients.framework.location.exceptions.ServiceDefinitionDoesNotExistException;
import com.microsoft.tfs.core.clients.framework.location.internal.LocationCacheManager;
import com.microsoft.tfs.core.clients.framework.location.internal.LocationWebServiceProxy;
import com.microsoft.tfs.core.clients.framework.location.internal.ServiceTypeFilter;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class LocationService
implements ServerDataProvider {
    private final PersistenceStoreProvider persistenceProvider;
    private final URI connectionBaseURI;
    private final LocationWebServiceProxy webServiceProxy;
    private LocationCacheManager locationCacheManager;
    private final Object locationCacheManagerLock = new Object();
    private final Object connectionLock = new Object();
    private boolean connectionMade = false;
    private ConnectOptions validConnectionData = ConnectOptions.NONE;
    private TeamFoundationIdentity authorizedIdentity;
    private TeamFoundationIdentity authenticatedIdentity;
    private GUID instanceId;
    private GUID catalogResourceId;
    private ServerCapabilities serverCapabilities;
    private final Object serverDataLock = new Object();

    public LocationService(TFSConnection connection) {
        Check.notNull(connection, "connection");
        this.webServiceProxy = new LocationWebServiceProxy(connection);
        this.persistenceProvider = connection.getPersistenceStoreProvider();
        this.connectionBaseURI = connection.getBaseURI();
        this.locationCacheManager = new LocationCacheManager(this.persistenceProvider.getCachePersistenceStore(), GUID.EMPTY, this.connectionBaseURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocationCacheManager getLocationCacheManager() {
        Object object = this.locationCacheManagerLock;
        synchronized (object) {
            return this.locationCacheManager;
        }
    }

    @Override
    public AccessMapping configureAccessMapping(String moniker, String displayName, String accessPoint, boolean makeDefault) {
        throw new LocationMethodNotImplementedException("configureAccessMapping");
    }

    @Override
    public ServiceDefinition findServiceDefinition(String serviceType, GUID serviceIdentifier) {
        Check.notNull(serviceType, "serviceType");
        ServiceDefinition definition = this.getLocationCacheManager().findService(serviceType, serviceIdentifier);
        if (definition == null) {
            this.checkForServerUpdates();
            return this.getLocationCacheManager().findService(serviceType, serviceIdentifier);
        }
        return definition;
    }

    @Override
    public ServiceDefinition[] findServiceDefinitions(String serviceType) {
        ServiceDefinition[] definitions = this.getLocationCacheManager().findServices(serviceType);
        if (definitions == null) {
            this.checkForServerUpdates();
            return this.getLocationCacheManager().findServices(serviceType);
        }
        return definitions;
    }

    @Override
    public ServiceDefinition[] findServiceDefinitionsByToolType(String toolType) {
        ServiceDefinition[] definitions = this.getLocationCacheManager().findServicesByToolID(toolType);
        if (definitions == null) {
            this.checkForServerUpdates();
            return this.getLocationCacheManager().findServicesByToolID(toolType);
        }
        return definitions == null ? new ServiceDefinition[]{} : definitions;
    }

    @Override
    public AccessMapping getAccessMapping(String moniker) {
        Check.notNull(moniker, "moniker");
        this.ensureConnected(ConnectOptions.INCLUDE_SERVICES);
        return this.locationCacheManager.getAccessMapping(moniker);
    }

    @Override
    public AccessMapping getClientAccessMapping() {
        AccessMapping clientAccessMapping = this.getLocationCacheManager().getClientAccessMapping();
        if (clientAccessMapping == null) {
            this.ensureConnected(ConnectOptions.INCLUDE_SERVICES);
            clientAccessMapping = this.getLocationCacheManager().getClientAccessMapping();
        }
        return clientAccessMapping;
    }

    @Override
    public AccessMapping[] getConfiguredAccessMappings() {
        this.ensureConnected(ConnectOptions.INCLUDE_SERVICES);
        return this.getLocationCacheManager().getAccessMappings();
    }

    @Override
    public AccessMapping getDefaultAccessMapping() {
        AccessMapping defaultAccessMapping = this.locationCacheManager.getDefaultAccessMapping();
        if (defaultAccessMapping == null) {
            this.ensureConnected(ConnectOptions.INCLUDE_SERVICES);
            defaultAccessMapping = this.getLocationCacheManager().getDefaultAccessMapping();
        }
        return defaultAccessMapping;
    }

    @Override
    public String locationForAccessMapping(String serviceType, GUID serviceIdentifier, AccessMapping accessMapping) {
        ServiceDefinition serviceDefinition = this.findServiceDefinition(serviceType, serviceIdentifier);
        if (serviceDefinition == null) {
            throw new ServiceDefinitionDoesNotExistException(serviceType, serviceIdentifier);
        }
        return this.locationForAccessMapping(serviceDefinition, accessMapping);
    }

    @Override
    public String locationForAccessMapping(ServiceDefinition serviceDefinition, AccessMapping accessMapping) {
        return this.locationForAccessMapping(serviceDefinition, accessMapping, true);
    }

    @Override
    public String locationForAccessMapping(ServiceDefinition serviceDefinition, AccessMapping accessMapping, boolean encodeRelativeComponents) {
        URL url;
        Check.notNull(serviceDefinition, "serviceDefinition");
        Check.notNull(accessMapping, "accessMapping");
        if (serviceDefinition.getRelativeToSetting().toInt() == RelativeToSetting.FULLY_QUALIFIED.toInt()) {
            LocationMapping locationMapping = serviceDefinition.getLocationMapping(accessMapping);
            if (locationMapping != null) {
                return locationMapping.getLocation();
            }
            return null;
        }
        String accessPoint = accessMapping.getAccessPoint();
        if (accessPoint == null || accessPoint.length() == 0) {
            throw new InvalidAccessPointException();
        }
        try {
            url = new URL(accessPoint);
        }
        catch (MalformedURLException e) {
            throw new AccessPointIsMalformedURLException(accessPoint);
        }
        String properRoot = "";
        int setting = serviceDefinition.getRelativeToSetting().toInt();
        if (setting == RelativeToSetting.AUTHORITY.toInt()) {
            properRoot = url.getProtocol() + "://" + url.getHost();
        } else if (setting == RelativeToSetting.PORT.toInt()) {
            properRoot = url.getProtocol() + "://" + url.getAuthority();
        } else if (setting == RelativeToSetting.CONTEXT.toInt()) {
            properRoot = URIUtils.combinePaths(url.toString(), this.getLocationCacheManager().getWebApplicationRelativeDirectory(), encodeRelativeComponents);
        } else if (setting == RelativeToSetting.WEB_APPLICATION.toInt()) {
            properRoot = url.toString();
        } else {
            Check.isTrue(false, "unknown RelativeToString");
        }
        return URIUtils.combinePaths(properRoot, serviceDefinition.getRelativePath(), encodeRelativeComponents);
    }

    @Override
    public String locationForCurrentConnection(String serviceType, GUID serviceIdentifier) {
        ServiceDefinition serviceDefinition = this.findServiceDefinition(serviceType, serviceIdentifier);
        if (serviceDefinition == null) {
            return null;
        }
        return this.locationForCurrentConnection(serviceDefinition);
    }

    @Override
    public String locationForCurrentConnection(ServiceDefinition serviceDefinition) {
        String location = this.locationForAccessMapping(serviceDefinition, this.getClientAccessMapping());
        if (location == null && (location = this.locationForAccessMapping(serviceDefinition, this.getDefaultAccessMapping())) == null) {
            LocationMapping[] locationMappings = serviceDefinition.getLocationMappings();
            if (locationMappings == null || locationMappings.length == 0) {
                throw new InvalidServiceDefinitionException(serviceDefinition.getServiceType());
            }
            location = locationMappings[0].getLocation();
        }
        return location;
    }

    @Override
    public void removeAccessMapping(String moniker) {
        throw new LocationMethodNotImplementedException("removeAccessMapping");
    }

    @Override
    public void removeServiceDefinition(String serviceType, GUID serviceIdentifier) {
        throw new LocationMethodNotImplementedException("removeServiceDefinition");
    }

    @Override
    public void removeServiceDefinition(ServiceDefinition serviceDefinition) {
        throw new LocationMethodNotImplementedException("removeServiceDefinition");
    }

    @Override
    public void removeServiceDefinitions(ServiceDefinition[] serviceDefinitions) {
        throw new LocationMethodNotImplementedException("removeServiceDefinitions");
    }

    @Override
    public void saveServiceDefinition(ServiceDefinition serviceDefinition) {
        throw new LocationMethodNotImplementedException("saveServiceDefinition");
    }

    @Override
    public void saveServiceDefinitions(ServiceDefinition[] serviceDefinitions) {
        throw new LocationMethodNotImplementedException("saveServiceDefinitions");
    }

    @Override
    public void setDefaultAccessMapping(AccessMapping accessMapping) {
        throw new LocationMethodNotImplementedException("setDefaultAccessMapping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnectOptions connectOptions) {
        LocationCacheManager newLocationCacheManager;
        if (this.getLocationCacheManager().getAccessMappings().length == 0) {
            connectOptions = connectOptions.combine(ConnectOptions.INCLUDE_SERVICES);
        }
        boolean includeServices = connectOptions.contains(ConnectOptions.INCLUDE_SERVICES);
        int lastChangeId = this.getLocationCacheManager().getLastChangeID();
        ConnectionData connectionData = this.webServiceProxy.connect(connectOptions.toIntFlags(), lastChangeId);
        LocationServiceData locationServiceData = connectionData.getLocationServiceData();
        Object object = this.serverDataLock;
        synchronized (object) {
            this.authenticatedIdentity = connectionData.getAuthenticatedUser();
            this.authorizedIdentity = connectionData.getAuthorizedUser();
            this.instanceId = connectionData.getInstanceID();
            this.catalogResourceId = connectionData.getCatalogResourceID();
            this.serverCapabilities = new ServerCapabilities(connectionData.getServerCapabilities());
        }
        LocationCacheManager tempLocationCache = new LocationCacheManager(this.persistenceProvider.getCachePersistenceStore(), this.instanceId, this.connectionBaseURI);
        if (tempLocationCache.isLocalCacheAvailable()) {
            newLocationCacheManager = tempLocationCache;
        } else {
            newLocationCacheManager = new LocationCacheManager(this.persistenceProvider.getCachePersistenceStore(), this.instanceId, this.connectionBaseURI);
            this.validConnectionData = ConnectOptions.NONE;
        }
        Object object2 = this.locationCacheManagerLock;
        synchronized (object2) {
            this.locationCacheManager = newLocationCacheManager;
        }
        newLocationCacheManager.setWebApplicationRelativeDirectory(connectionData.getWebApplicationRelativeDirectory());
        if (locationServiceData != null) {
            newLocationCacheManager.loadServicesData(locationServiceData, includeServices);
        }
        this.validConnectionData = this.validConnectionData.combine(connectOptions);
        this.connectionMade = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForServerUpdates() {
        boolean checkedForUpdates = false;
        if (this.needToConnect(ConnectOptions.INCLUDE_SERVICES)) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.needToConnect(ConnectOptions.INCLUDE_SERVICES)) {
                    this.connect(ConnectOptions.INCLUDE_SERVICES);
                    checkedForUpdates = true;
                }
            }
        }
        if (!checkedForUpdates) {
            LocationServiceData data = this.webServiceProxy.queryServices(ServiceTypeFilter.ALL, this.getLocationCacheManager().getLastChangeID());
            this.getLocationCacheManager().loadServicesData(data, true);
        }
    }

    private boolean needToConnect(ConnectOptions optionsNeeded) {
        boolean identitySame = true;
        return !this.connectionMade || !this.validConnectionData.containsAll(optionsNeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConnected(ConnectOptions optionsNeeded) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.needToConnect(optionsNeeded)) {
                this.connect(optionsNeeded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TeamFoundationIdentity getAuthorizedIdentity() {
        this.ensureAuthenticated();
        Object object = this.serverDataLock;
        synchronized (object) {
            Check.notNull(this.authorizedIdentity, "this.authorizedIdentity");
            return this.authorizedIdentity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TeamFoundationIdentity getAuthenticatedIdentity() {
        this.ensureConnected(ConnectOptions.NONE);
        Object object = this.serverDataLock;
        synchronized (object) {
            Check.notNull(this.authenticatedIdentity, "authenticatedIdentity");
            return this.authenticatedIdentity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAuthenticated() {
        Object object = this.serverDataLock;
        synchronized (object) {
            return this.authenticatedIdentity != null;
        }
    }

    @Override
    public void ensureAuthenticated() {
        this.ensureConnected(ConnectOptions.NONE);
    }

    @Override
    public void authenticate() {
        this.connect(ConnectOptions.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID getCatalogResourceID() {
        this.ensureConnected(ConnectOptions.NONE);
        Object object = this.serverDataLock;
        synchronized (object) {
            return this.catalogResourceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID getInstanceID() {
        this.ensureConnected(ConnectOptions.NONE);
        Object object = this.serverDataLock;
        synchronized (object) {
            return this.instanceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerCapabilities getServerCapabilities() {
        this.ensureConnected(ConnectOptions.NONE);
        Object object = this.serverDataLock;
        synchronized (object) {
            return this.serverCapabilities;
        }
    }

    @Override
    public String findServerLocation(GUID serverGuid) {
        return this.locationForCurrentConnection("LocationService", serverGuid);
    }

    @Override
    public void reactToPossibleServerUpdate(int serverLastChangeId) {
        this.getLocationCacheManager().clearIfCacheNotFresh(serverLastChangeId);
    }
}

