/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaselineFileDownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.AbstractDownloadWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaselineDownloadWorker
extends AbstractDownloadWorker {
    private static final Log log = LogFactory.getLog(BaselineDownloadWorker.class);
    private final AsyncOperation asyncOp;
    private final String downloadURL;
    private final BaselineFolderCollection baselineFolders;
    private final byte[] baselineFileGUID;

    public BaselineDownloadWorker(EventSource eventSource, TaskMonitor cancelMonitor, VersionControlClient client, AsyncOperation asyncOp, String downloadURL, BaselineFolderCollection baselineFolders, byte[] baselineFileGUID) {
        super(eventSource, cancelMonitor, client);
        Check.notNull(asyncOp, "asyncOp");
        Check.notNull(downloadURL, "downloadURL");
        Check.notNull(baselineFolders, "baselineFolders");
        Check.notNull(baselineFileGUID, "baselineFileGUID");
        this.asyncOp = asyncOp;
        this.downloadURL = downloadURL;
        this.baselineFolders = baselineFolders;
        this.baselineFileGUID = baselineFileGUID;
    }

    @Override
    public WorkerStatus call() throws Exception {
        try {
            if (this.getCancelMonitor().isCanceled()) {
                return new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
            }
            this.downloadBaselineFile();
        }
        catch (CanceledException e) {
            return new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
        }
        catch (Throwable t) {
            this.asyncOp.setFatalError(t);
            return new WorkerStatus(this, WorkerStatus.FinalState.ERROR);
        }
        return new WorkerStatus(this, WorkerStatus.FinalState.NORMAL);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void downloadBaselineFile() throws CanceledException {
        BaselineFileDownloadOutput baselineOutput;
        File baselineTempFile;
        block6: {
            int readLockToken = 0;
            baselineTempFile = null;
            baselineOutput = null;
            try {
                readLockToken = this.baselineFolders.lockForRead();
                String baselineFileNoSuffix = this.baselineFolders.getNewBaselineLocation(this.baselineFileGUID, null, readLockToken);
                baselineOutput = new BaselineFileDownloadOutput(new File(baselineFileNoSuffix), false);
                this.getClient().downloadFileToStreams(new DownloadSpec(this.downloadURL), new DownloadOutput[]{baselineOutput}, this.getEventSource(), this.getCancelMonitor());
                baselineTempFile = baselineOutput.isTempFileCreatedInsteadOfBaseline() ? baselineOutput.getOutputStreamFile() : null;
                this.closeDownloadOutputStreamSafely(baselineOutput);
                if (readLockToken == 0) break block6;
            }
            catch (CanceledException e) {
                try {
                    throw e;
                    catch (VersionControlException e2) {
                        String message = MessageFormat.format(Messages.getString("BaselineDownloadWorker.ErrorDownloadingBaselineFileFormat"), this.baselineFileGUID, e2.getLocalizedMessage());
                        log.warn((Object)message, (Throwable)e2);
                        throw new VersionControlException(message, e2);
                    }
                }
                catch (Throwable throwable) {
                    if (readLockToken != 0) {
                        this.baselineFolders.unlockForRead(readLockToken);
                    }
                    this.closeDownloadOutputStreamSafely(baselineOutput);
                    if (baselineTempFile == null) throw throwable;
                    baselineTempFile.delete();
                    throw throwable;
                }
            }
            this.baselineFolders.unlockForRead(readLockToken);
        }
        this.closeDownloadOutputStreamSafely(baselineOutput);
        if (baselineTempFile == null) return;
        baselineTempFile.delete();
    }
}

