/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChangeComparatorType;
import com.microsoft.tfs.util.Check;
import java.util.Comparator;

public final class PendingChangeComparator
implements Comparator<PendingChange> {
    private final PendingChangeComparatorType sortType;

    public PendingChangeComparator(PendingChangeComparatorType sortType) {
        Check.notNull(sortType, "sortType");
        this.sortType = sortType;
    }

    @Override
    public int compare(PendingChange first, PendingChange second) {
        if (this.sortType == PendingChangeComparatorType.LOCAL_ITEM || this.sortType == PendingChangeComparatorType.LOCAL_ITEM_REVERSE) {
            if (first.getLocalItem() == null && second.getLocalItem() == null) {
                return ServerPath.compareTopDown(first.getLocalItem(), second.getLocalItem());
            }
            if (first.getLocalItem() == null) {
                return 1;
            }
            if (second.getLocalItem() == null) {
                return -1;
            }
            if (this.sortType == PendingChangeComparatorType.LOCAL_ITEM) {
                return LocalPath.compareTopDown(first.getLocalItem(), second.getLocalItem());
            }
            if (this.sortType == PendingChangeComparatorType.LOCAL_ITEM_REVERSE) {
                return LocalPath.compareBottomUp(first.getLocalItem(), second.getLocalItem());
            }
        } else if (this.sortType == PendingChangeComparatorType.SERVER_ITEM) {
            return ServerPath.compareTopDown(first.getServerItem(), second.getServerItem());
        }
        return 0;
    }
}

