/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.CheckinNotificationWorkItemInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkItemCheckedInfo;
import com.microsoft.tfs.core.clients.workitem.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class WorkItemCheckinInfo {
    private final WorkItem workItem;
    private CheckinWorkItemAction action;

    public WorkItemCheckinInfo(WorkItem workItem) {
        this.workItem = workItem;
    }

    public WorkItemCheckinInfo(WorkItem workItem, CheckinWorkItemAction action) {
        this.workItem = workItem;
        this.action = action;
    }

    public String toString() {
        String messageFormat = Messages.getString("WorkItemCheckinInfo.WorkItemCheckinInfoFormat");
        return MessageFormat.format(messageFormat, Integer.toString(this.workItem.getFields().getID()), this.action.toString());
    }

    public CheckinWorkItemAction getAction() {
        return this.action;
    }

    public void clearAction() {
        this.action = null;
    }

    public void setActionToDefault() {
        this.action = this.getAvailableActions()[0];
    }

    public void setActionFromString(String s) {
        this.action = CheckinWorkItemAction.fromString(s);
    }

    public void setAction(CheckinWorkItemAction newAction) {
        this.action = newAction;
    }

    public CheckinNotificationWorkItemInfo getNotification() {
        if (this.action == null) {
            this.action = CheckinWorkItemAction.ASSOCIATE;
        }
        return new CheckinNotificationWorkItemInfo(this.workItem.getFields().getID(), this.action);
    }

    public WorkItem getWorkItem() {
        return this.workItem;
    }

    public String getActionString() {
        return this.action == null ? "" : this.action.toUIString();
    }

    public String[] getAvailableActionStrings() {
        CheckinWorkItemAction[] actions = this.getAvailableActions();
        String[] strings = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            strings[i] = actions[i].toString();
        }
        return strings;
    }

    public boolean isResolveSupported() {
        return this.isActionSupported(CheckinWorkItemAction.RESOLVE);
    }

    public boolean isActionSupported(CheckinWorkItemAction action) {
        CheckinWorkItemAction[] available = this.getAvailableActions();
        for (int i = 0; i < available.length; ++i) {
            if (!available[i].equals(action)) continue;
            return true;
        }
        return false;
    }

    public CheckinWorkItemAction[] getAvailableActions() {
        if (this.workItem.getNextState("Microsoft.VSTS.Actions.Checkin") != null) {
            return new CheckinWorkItemAction[]{CheckinWorkItemAction.ASSOCIATE, CheckinWorkItemAction.RESOLVE};
        }
        return new CheckinWorkItemAction[]{CheckinWorkItemAction.ASSOCIATE};
    }

    public static WorkItemCheckinInfo[] fromWorkItemCheckedInfo(WorkItemClient workItemClient, WorkItemCheckedInfo[] checkedInfo) {
        Check.notNull(workItemClient, "workItemClient");
        WorkItemCheckinInfo[] ret = null;
        if (checkedInfo != null) {
            ret = new WorkItemCheckinInfo[checkedInfo.length];
            for (int i = 0; i < checkedInfo.length; ++i) {
                WorkItem wi = workItemClient.getWorkItemByID(checkedInfo[i].getID());
                ret[i] = new WorkItemCheckinInfo(wi, checkedInfo[i].getCheckinAction());
            }
        }
        return ret;
    }
}

