/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal;

public class DownloadURL {
    private static final String FILE_ID_SEARCH_STRING = "&fid=";
    private final String queryString;
    private final int fileID;

    public DownloadURL(String queryString) {
        String fileIdString;
        int pos;
        this.queryString = queryString;
        if (queryString == null || queryString.length() == 0) {
            this.fileID = 0;
            return;
        }
        if (queryString.startsWith(FILE_ID_SEARCH_STRING.substring(1))) {
            pos = FILE_ID_SEARCH_STRING.length() - 1;
        } else {
            pos = queryString.indexOf(FILE_ID_SEARCH_STRING);
            if (pos < 0) {
                this.fileID = 0;
                return;
            }
            pos += FILE_ID_SEARCH_STRING.length();
        }
        if (pos == queryString.length()) {
            this.fileID = 0;
            return;
        }
        int endPos = queryString.indexOf(38, pos);
        if (endPos < 0) {
            endPos = queryString.length();
        }
        if ((fileIdString = queryString.substring(pos, endPos)) == null || fileIdString.length() == 0) {
            this.fileID = 0;
            return;
        }
        int id = 0;
        try {
            id = Integer.parseInt(fileIdString);
        }
        catch (NumberFormatException e) {
            id = 0;
        }
        this.fileID = id;
    }

    public boolean isContentDestroyed() {
        return null != this.queryString && this.fileID == 1023;
    }

    public int getFileID() {
        return this.fileID;
    }

    public String getURL() {
        return this.queryString;
    }
}

