/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.exceptions;

import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;

public class WorkItemLinkValidationException
extends WorkItemException {
    private static final long serialVersionUID = -4442222895050498396L;
    private Type type;

    public WorkItemLinkValidationException(String message) {
        super(message);
    }

    public WorkItemLinkValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public WorkItemLinkValidationException(String message, Throwable cause, int errorId, Type type) {
        super(message, cause, errorId);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static class Type {
        public static final Type LINK_TYPE_NOT_FOUND = new Type("LinkTypeNotFound", 0);
        public static final Type LINK_NOT_FOUND = new Type("LinkNotFound", 1);
        public static final Type ADD_LINK_CANNOT_LINK_TO_SELF = new Type("AddLinkCannotLinkToSelf", 2);
        public static final Type ADD_LINK_DISABLED_TYPE = new Type("AddLinkDisabledType", 3);
        public static final Type ADD_LINK_CIRCULARITY = new Type("AddLinkCircularity", 4);
        public static final Type ADD_LINK_EXTRA_PARENT = new Type("AddLinkExtraParent", 5);
        public static final Type ADD_LINK_CHILD_IS_ANCESTOR = new Type("AddLinkChildIsAncestor", 6);
        public static final Type ADD_LINK_ALREADY_EXISTS = new Type("AddLinkAlreadyExists", 7);
        public static final Type ADD_LINK_MAX_DEPTH_EXCEEDED = new Type("AddLinkMaxDepthExceeded", 8);
        private final String name;
        private final int value;

        private Type(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }
}

