/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IConstantSet;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.SpecialConstantIDs;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.NodeMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.rules.Rule;
import com.microsoft.tfs.util.PrimitiveArrayHelpers;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllowedValuesHelper {
    private static final Log log = LogFactory.getLog(AllowedValuesHelper.class);
    private final int fieldDefinitionId;
    private final int internalFieldType;
    private final WITContext witContext;

    public AllowedValuesHelper(int fieldDefinitionId, int internalFieldType, WITContext witContext) {
        this.fieldDefinitionId = fieldDefinitionId;
        this.internalFieldType = internalFieldType;
        this.witContext = witContext;
    }

    public String[] compute() {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("computing allowed values for field: {0}", Integer.toString(this.fieldDefinitionId)));
        }
        if ((this.internalFieldType & 0xF0) == 160) {
            return this.computeValuesForTreeNodesWithType(this.fieldDefinitionId);
        }
        if (this.fieldDefinitionId == -12) {
            return this.computeAllNodeNameValues();
        }
        if (this.fieldDefinitionId == -11) {
            return this.computeAllNodeTypeValues();
        }
        if (this.fieldDefinitionId == -1) {
            return this.computeAllPersonNameValues();
        }
        return this.computeFromRules(this.fieldDefinitionId);
    }

    private String[] computeValuesForTreeNodesWithType(int typeId) {
        NodeMetadata[] nodes = this.witContext.getMetadata().getHierarchyTable().getNodesWithTypeID(typeId);
        return this.computeNodeNames(nodes);
    }

    private String[] computeAllNodeNameValues() {
        NodeMetadata[] allNodes = this.witContext.getMetadata().getHierarchyTable().getAllNodes();
        return this.computeNodeNames(allNodes);
    }

    private String[] computeAllNodeTypeValues() {
        return null;
    }

    private String[] computeAllPersonNameValues() {
        IConstantSet constantSet = this.witContext.getMetadata().getConstantHandler().getConstantSet(-2, true, true, true, true, false);
        return constantSet.toArray();
    }

    private String[] computeNodeNames(NodeMetadata[] nodeMetadataArray) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < nodeMetadataArray.length; ++i) {
            names.add(nodeMetadataArray[i].getName());
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] computeFromRules(int fieldIdForRules) {
        int i;
        List[] ruleSlots = new List[16];
        HashSet<String> allowedValueSet = new HashSet<String>();
        Rule[] rules = this.witContext.getMetadata().getRulesTable().getRulesForThenFieldID(fieldIdForRules);
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("allowed values({0}): found {1} candidate rule(s)", Integer.toString(this.fieldDefinitionId), rules.length));
        }
        for (i = 0; i < rules.length; ++i) {
            int slotIndex;
            if (!this.shouldUseRule(rules[i])) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("allowed values for {0} using rule {1}: thenConst={2} oneLevel={3} twoPlus={4} leaf={5} interior={6}", Integer.toString(this.fieldDefinitionId), Integer.toString(rules[i].getRuleID()), Integer.toString(rules[i].getThenConstID()), rules[i].isFlagThenOneLevel(), rules[i].isFlagThenTwoPlusLevels(), rules[i].isFlagThenLeaf(), rules[i].isFlagThenInterior()));
            }
            if (ruleSlots[slotIndex = this.calculateIndex(rules[i])] == null) {
                ruleSlots[slotIndex] = new ArrayList();
            }
            ruleSlots[slotIndex].add(new Integer(rules[i].getThenConstID()));
        }
        for (i = 0; i < ruleSlots.length; ++i) {
            List rootIdList = ruleSlots[i];
            if (rootIdList == null) continue;
            IConstantSet constantSet = this.createConstantSetFromSlot(rootIdList, i);
            allowedValueSet.addAll(constantSet.getValues());
        }
        return allowedValueSet.toArray(new String[0]);
    }

    private boolean shouldUseRule(Rule rule) {
        boolean shouldUseRule = false;
        if (rule.isFlagSuggestion()) {
            shouldUseRule = true;
        } else if (rule.isFlagDenyWrite()) {
            boolean bl = shouldUseRule = !rule.isFlagThenLike() && !SpecialConstantIDs.isSpecialConstantID(rule.getThenConstID()) && rule.isFlagUnless() != rule.isFlagThenNot();
        }
        if (!shouldUseRule && log.isTraceEnabled()) {
            if (!rule.isFlagDenyWrite() && !rule.isFlagSuggestion()) {
                log.trace((Object)MessageFormat.format("allowedvalues({0}): rejecting rule {1} - not a denywrite or a suggestion rule", Integer.toString(this.fieldDefinitionId), Integer.toString(rule.getRuleID())));
            }
            if (rule.isFlagDenyWrite()) {
                if (rule.isFlagThenLike()) {
                    log.trace((Object)MessageFormat.format("allowedvalues({0}): rejecting denywrite rule {1} - a pattern match rule", Integer.toString(this.fieldDefinitionId), Integer.toString(rule.getRuleID())));
                } else if (SpecialConstantIDs.isSpecialConstantID(rule.getThenConstID())) {
                    log.trace((Object)MessageFormat.format("allowedvalues({0}): rejecting denywrite rule {1} - thenconstid is a special constant", Integer.toString(this.fieldDefinitionId), Integer.toString(rule.getRuleID())));
                } else if (rule.isFlagUnless() == rule.isFlagThenNot()) {
                    log.trace((Object)MessageFormat.format("allowedvalues({0}): rejecting denywrite rule {1} - unless == thennot", Integer.toString(this.fieldDefinitionId), Integer.toString(rule.getRuleID())));
                }
            }
        }
        return shouldUseRule;
    }

    private int calculateIndex(Rule rule) {
        return (rule.isFlagThenOneLevel() ? 1 : 0) * 8 + (rule.isFlagThenTwoPlusLevels() ? 1 : 0) * 4 + (rule.isFlagThenLeaf() ? 1 : 0) * 2 + (rule.isFlagThenInterior() ? 1 : 0) * 1;
    }

    private IConstantSet createConstantSetFromSlot(List rootIdList, int slotIx) {
        int[] rootIds = new int[rootIdList.size()];
        for (int loopIx = 0; loopIx < rootIds.length; ++loopIx) {
            rootIds[loopIx] = (Integer)rootIdList.get(loopIx);
        }
        int x = slotIx;
        boolean oneLevel = x / 8 == 1;
        boolean twoPlusLevels = (x %= 8) / 4 == 1;
        boolean leaf = (x %= 4) / 2 == 1;
        boolean interior = (x %= 2) / 1 == 1;
        IConstantSet constantSet = this.witContext.getMetadata().getConstantHandler().getConstantSet(rootIds, oneLevel, twoPlusLevels, leaf, interior, false);
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("constant set from root ids {0} (oneLevel={1} twoPlus={2} leaf={3} interior={4}): {5}", PrimitiveArrayHelpers.asList(rootIds).toString(), oneLevel, twoPlusLevels, leaf, interior, constantSet.getSize()));
        }
        return constantSet;
    }
}

